/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.io;

import com.tvd12.ezyfox.util.EzyArrayUtil;
import com.tvd12.ezyfox.util.EzyDirectories;
import com.tvd12.ezyfox.util.EzyFileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.youngmonkeys.ezyplatform.data.FileItem;
import org.youngmonkeys.ezyplatform.exception.FilePermissionException;

public final class FolderProxy {
    private FolderProxy() {
    }

    public static void writeDistinctLines(File file, String newLine) {
        FolderProxy.writeDistinctLines(file, Collections.singletonList(newLine));
    }

    public static void writeDistinctLines(File file, Collection<String> newLines) {
        List lines;
        Path filePath = file.toPath();
        FolderProxy.createNewFile(file);
        try {
            lines = Stream.concat(newLines.stream(), Files.lines(filePath)).distinct().sorted().collect(Collectors.toList());
        }
        catch (Exception e) {
            throw FilePermissionException.fromFileAction(file, "read");
        }
        try {
            Files.write(filePath, lines, new OpenOption[0]);
        }
        catch (Exception e) {
            throw FilePermissionException.fromFileAction(file, "write");
        }
    }

    public static List<File> listFolders(File folder) {
        File[] files = null;
        if (folder.exists()) {
            files = folder.listFiles();
        }
        File[] tmp = files != null ? files : new File[]{};
        ArrayList<File> answer = new ArrayList<File>();
        for (File f : tmp) {
            if (!f.isDirectory()) continue;
            answer.add(f);
        }
        return answer;
    }

    public static void mkdir(File folder) {
        if (folder.exists()) {
            return;
        }
        if (!folder.mkdir()) {
            throw FilePermissionException.fromFolderAction(folder, "create");
        }
    }

    public static void mkdirs(File folder) {
        if (folder.exists()) {
            return;
        }
        if (!folder.mkdirs()) {
            throw FilePermissionException.fromFolderAction(folder, "create");
        }
    }

    public static void createNewFile(File file) {
        boolean result;
        if (file.exists()) {
            return;
        }
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            FolderProxy.mkdirs(parent);
        }
        try {
            result = file.createNewFile();
        }
        catch (IOException e) {
            throw FilePermissionException.fromFileAction(file, "create", e);
        }
        if (!result) {
            throw FilePermissionException.fromFileAction(file, "create");
        }
    }

    public static void copyFile(File from, File to) {
        try {
            EzyFileUtil.copyFile((File)from, (File)to);
        }
        catch (Exception e) {
            throw FilePermissionException.fromFolderAction(to, "copy to", e);
        }
    }

    public static void deleteFile(File file) {
        if (file.exists() && !file.delete()) {
            throw FilePermissionException.fromFileAction(file, "delete");
        }
    }

    public static void deleteFolder(File folder) {
        try {
            if (folder.exists()) {
                EzyDirectories.deleteFolder((File)folder);
            }
        }
        catch (IOException e) {
            throw FilePermissionException.fromFolderAction(folder, "delete", e);
        }
    }

    public static void deleteFileOrFolder(File fileOrFolder) {
        if (fileOrFolder.isFile()) {
            FolderProxy.deleteFile(fileOrFolder);
        } else {
            FolderProxy.deleteFolder(fileOrFolder);
        }
    }

    public static void clearFolder(File folder) {
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            FolderProxy.deleteFileOrFolder(file);
        }
    }

    public static void copyFolder(File from, File to) {
        try {
            EzyDirectories.copyFolder((File)from, (File)to);
        }
        catch (IOException e) {
            throw FilePermissionException.fromFolderAction(to, "copy to", e);
        }
    }

    public static void copyAndDeleteFolder(File from, File to) {
        FolderProxy.copyFolder(from, to);
        FolderProxy.deleteFolder(from);
    }

    public static void moveFile(File file, File toFolder) {
        File newLocationFile = Paths.get(toFolder.toString(), file.getName()).toFile();
        FolderProxy.createNewFile(newLocationFile);
        try {
            Files.move(file.toPath(), newLocationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw FilePermissionException.fromFolderAction(newLocationFile, "move to", e);
        }
    }

    public static File subpath(File file, File parent) {
        return EzyDirectories.subpath((File)file, (File)parent);
    }

    public static String getFileExtension(String fileName) {
        return EzyFileUtil.getFileExtension((String)fileName);
    }

    public static List<FileItem> listFileItems(File rootFolder, int maxLevel, Predicate<File> filter) {
        FileItem.FileItemMutable root = new FileItem.FileItemMutable().setFile(rootFolder);
        LinkedList<FileItem.FileItemMutable> queue = new LinkedList<FileItem.FileItemMutable>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            Object[] files;
            FileItem.FileItemMutable parent = (FileItem.FileItemMutable)queue.poll();
            if (parent.getLevel() >= maxLevel || EzyArrayUtil.isEmpty((Object[])(files = parent.getFile().listFiles()))) continue;
            for (Object file : files) {
                if (!filter.test((File)file)) continue;
                FileItem.FileItemMutable fileItem = new FileItem.FileItemMutable().setFile((File)file).setLevel(parent.getLevel() + 1).setParent(parent).setRelativePath(((File)file).getAbsolutePath().substring(rootFolder.getAbsolutePath().length() + 1));
                parent.addChild(fileItem);
                if (!((File)file).isDirectory()) continue;
                queue.offer(fileItem);
            }
        }
        return root.flatChildren();
    }

    public static Predicate<File> isNotHiddenFilePredicate() {
        return f -> !f.isHidden();
    }

    public static Predicate<File> fileHasNotExtensionPredicate(String extension) {
        return f -> f.isDirectory() || !f.getPath().endsWith(extension);
    }
}

