/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;

public final class CollectionFunctions {
    private CollectionFunctions() {
    }

    public static <E, C extends Collection<E>> C toNullIfEmpty(C collection) {
        return (C)(collection == null || !collection.isEmpty() ? collection : null);
    }

    public static <E> Collection<E> toEmptyIfNull(Collection<E> collection) {
        return collection == null ? Collections.emptyList() : collection;
    }

    public static <E, V> List<E> distinctByField(Collection<E> collection, Function<E, V> fieldValueExtractor) {
        HashSet<V> distinctValues = new HashSet<V>();
        ArrayList<E> newList = new ArrayList<E>();
        for (E item : collection) {
            V fieldValue = fieldValueExtractor.apply(item);
            if (distinctValues.contains(fieldValue)) continue;
            distinctValues.add(fieldValue);
            newList.add(item);
        }
        return newList;
    }
}

