/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.asm;

import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClassTree;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestCookie;
import com.tvd12.ezyhttp.server.core.annotation.RequestHeader;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.asm.AbstractHandlerImplementer;
import com.tvd12.ezyhttp.server.core.handler.AbstractRequestHandler;
import com.tvd12.ezyhttp.server.core.handler.RequestHandler;
import com.tvd12.ezyhttp.server.core.handler.RequestURIDecorator;
import com.tvd12.ezyhttp.server.core.reflect.ControllerProxy;
import com.tvd12.ezyhttp.server.core.reflect.ExceptionHandlerMethod;
import com.tvd12.ezyhttp.server.core.reflect.RequestHandlerMethod;
import com.tvd12.ezyhttp.server.core.reflect.RequestParameters;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import com.tvd12.ezyhttp.server.core.util.PathVariableAnnotations;
import com.tvd12.ezyhttp.server.core.util.RequestCookieAnnotations;
import com.tvd12.ezyhttp.server.core.util.RequestHeaderAnnotations;
import com.tvd12.ezyhttp.server.core.util.RequestParamAnnotations;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewMethod;
import lombok.Generated;

public class RequestHandlerImplementer
extends AbstractHandlerImplementer<RequestHandlerMethod> {
    private static boolean debug;
    protected final boolean isAsync;
    protected final ControllerProxy controller;
    protected RequestURIDecorator requestURIDecorator;
    protected static final String PARAMETER_PREFIX = "param";
    protected static final AtomicInteger COUNT;

    public RequestHandlerImplementer(ControllerProxy controller, RequestHandlerMethod handlerMethod) {
        super(handlerMethod);
        this.controller = controller;
        this.isAsync = handlerMethod.isAsync();
    }

    public RequestHandler implement() {
        try {
            return this.doImplement();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected RequestHandler doImplement() throws Exception {
        ClassPool pool = ClassPool.getDefault();
        String implClassName = this.getImplClassName();
        CtClass implClass = pool.makeClass(implClassName);
        EzyClass superClass = new EzyClass(this.getSuperClass());
        String controllerFieldContent = this.makeControllerFieldContent();
        String setControllerMethodContent = this.makeSetControllerMethodContent();
        String handleRequestMethodContent = this.makeHandleRequestMethodContent();
        String handleExceptionMethodContent = this.makeHandleExceptionMethodContent();
        String getHttpMethodMethodContent = this.makeGetHttpMethodMethodContent();
        String getRequestURIMethodContent = this.makeGetRequestURIMethodContent();
        String getResponseContentTypeMethodContent = this.makeGetResponseContentTypeMethodContent();
        String isAsyncMethodContent = this.makeIsAsyncMethodContent();
        this.printComponentContent(controllerFieldContent);
        this.printComponentContent(setControllerMethodContent);
        this.printComponentContent(handleRequestMethodContent);
        this.printComponentContent(handleExceptionMethodContent);
        this.printComponentContent(getHttpMethodMethodContent);
        this.printComponentContent(getRequestURIMethodContent);
        this.printComponentContent(getResponseContentTypeMethodContent);
        this.printComponentContent(isAsyncMethodContent);
        implClass.setSuperclass(pool.get(superClass.getName()));
        implClass.addField(CtField.make((String)controllerFieldContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)setControllerMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)handleRequestMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)handleExceptionMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)getHttpMethodMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)getRequestURIMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)getResponseContentTypeMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)isAsyncMethodContent, (CtClass)implClass));
        Class answerClass = implClass.toClass();
        implClass.detach();
        RequestHandler handler = (RequestHandler)answerClass.newInstance();
        handler.setHandlerMethod(((RequestHandlerMethod)this.handlerMethod).getMethod().getMethod());
        this.setRepoComponent(handler);
        return handler;
    }

    protected void setRepoComponent(RequestHandler handler) {
        handler.setController(this.controller.getInstance());
    }

    protected String makeControllerFieldContent() {
        return new EzyInstruction().append("private ").append(this.controller.getClazz().getName()).append(" controller").toString();
    }

    protected String makeSetControllerMethodContent() {
        return new EzyFunction(this.getSetControllerMethod()).body().append(new EzyInstruction("\t", "\n").append("this.controller").equal().brackets(this.controller.getClazz().getClazz()).append("arg0")).function().toString();
    }

    protected String makeHandleRequestMethodContent() {
        Parameter[] parameters;
        EzyMethod method = this.getHandleRequestMethod();
        EzyFunction function = new EzyFunction(method).throwsException();
        EzyFunction.EzyBody body = function.body();
        int paramCount = 0;
        int headerCount = 0;
        int parameterCount = 0;
        int pathVariableCount = 0;
        int cookieCount = 0;
        for (Parameter parameter : parameters = ((RequestHandlerMethod)this.handlerMethod).getParameters()) {
            RequestBody requestBodyAnno;
            RequestCookie requestCookieAnno;
            PathVariable pathVariableAnno;
            String valueExpression;
            RequestHeader requestHeaderAnno;
            String valueExpression2;
            Class<?> parameterType = parameter.getType();
            Class<?> genericType = this.getGenericType(parameter);
            String genericTypeClass = genericType != null ? genericType.getName() + ".class" : "null";
            EzyInstruction instruction = new EzyInstruction("\t", "\n").clazz(parameterType).append(" ").append(PARAMETER_PREFIX).append((Object)paramCount).equal();
            boolean hasAnnotation = false;
            RequestParam requestParamAnno = parameter.getAnnotation(RequestParam.class);
            if (requestParamAnno != null) {
                String paramKey = RequestParamAnnotations.getParamKeyString(requestParamAnno, parameterCount);
                String defaultValue = requestParamAnno.defaultValue();
                String getValueExpression = defaultValue.equals("null") ? "arg0.getParameter(" + paramKey + ")" : "arg0.getParameter(" + paramKey + ", " + EzyStrings.quote((Object)defaultValue) + ")";
                valueExpression2 = "this.deserializeParameter(" + paramKey + ", " + getValueExpression + ", " + parameterType.getTypeName() + ".class, " + genericTypeClass + ")";
                instruction.cast(parameterType, valueExpression2);
                ++parameterCount;
                hasAnnotation = true;
            }
            if ((requestHeaderAnno = parameter.getAnnotation(RequestHeader.class)) != null) {
                String headerKey = RequestHeaderAnnotations.getHeaderKeyString(requestHeaderAnno, headerCount);
                String defaultValue = requestHeaderAnno.defaultValue();
                String getValueExpression = defaultValue.equals("null") ? "arg0.getHeader(" + headerKey + ")" : "arg0.getHeader(" + headerKey + ", " + EzyStrings.quote((Object)defaultValue) + ")";
                valueExpression = "this.deserializeHeader(" + headerKey + ", " + getValueExpression + ", " + parameterType.getTypeName() + ".class, " + genericTypeClass + ")";
                instruction.cast(parameterType, valueExpression);
                ++headerCount;
                hasAnnotation = true;
            }
            if ((pathVariableAnno = parameter.getAnnotation(PathVariable.class)) != null) {
                String varNameKey = PathVariableAnnotations.getVariableNameKeyString(pathVariableAnno, pathVariableCount);
                valueExpression2 = "this.deserializePathVariable(" + varNameKey + ", arg0.getPathVariable(" + varNameKey + "), " + parameterType.getTypeName() + ".class, " + genericTypeClass + ")";
                instruction.cast(parameterType, valueExpression2);
                ++pathVariableCount;
                hasAnnotation = true;
            }
            if ((requestCookieAnno = parameter.getAnnotation(RequestCookie.class)) != null) {
                String cookieKey = RequestCookieAnnotations.getCookieKeyString(requestCookieAnno, cookieCount);
                String defaultValue = requestCookieAnno.defaultValue();
                String getValueExpression = defaultValue.equals("null") ? "arg0.getCookieValue(" + cookieKey + ")" : "arg0.getCookieValue(" + cookieKey + ", " + EzyStrings.quote((Object)defaultValue) + ")";
                String valueExpression3 = "this.deserializeCookie(" + cookieKey + ", " + getValueExpression + ", " + parameterType.getTypeName() + ".class, " + genericTypeClass + ")";
                instruction.cast(parameterType, valueExpression3);
                ++cookieCount;
                hasAnnotation = true;
            }
            if ((requestBodyAnno = parameter.getAnnotation(RequestBody.class)) != null) {
                instruction.brackets(parameterType).append("this.deserializeBody(").append("arg0, ").clazz(parameterType, true).append(")");
                hasAnnotation = true;
            }
            if (!hasAnnotation) {
                valueExpression = "arg0";
                if (parameterType != RequestArguments.class) {
                    String argumentKey = RequestParameters.getArgumentKeyString(parameter);
                    valueExpression = "arg0.getArgument(" + argumentKey + ")";
                }
                instruction.cast(parameterType, valueExpression);
            }
            body.append(instruction);
            ++paramCount;
        }
        EzyInstruction instruction = new EzyInstruction("\t", "\n");
        Class<?> returnType = ((RequestHandlerMethod)this.handlerMethod).getReturnType();
        if (returnType != Void.TYPE) {
            instruction.answer();
        }
        StringBuilder answerExpression = new StringBuilder();
        answerExpression.append("this.controller.").append(((RequestHandlerMethod)this.handlerMethod).getName()).append("(");
        for (int i = 0; i < paramCount; ++i) {
            answerExpression.append(PARAMETER_PREFIX).append(i);
            if (i >= paramCount - 1) continue;
            answerExpression.append(", ");
        }
        answerExpression.append(")");
        if (returnType != Void.TYPE) {
            instruction.valueOf(returnType, answerExpression.toString());
        } else {
            instruction.append((Object)answerExpression);
        }
        body.append(instruction);
        if (returnType == Void.TYPE) {
            body.append(new EzyInstruction("\t", "\n").append("return null"));
        }
        return function.toString();
    }

    protected String makeHandleExceptionMethodContent() {
        EzyMethod method = this.getHandleExceptionMethod();
        EzyFunction function = new EzyFunction(method).throwsException();
        EzyFunction.EzyBody body = function.body();
        Map<Class<?>, ExceptionHandlerMethod> exceptionHandlerMethodMap = this.controller.getExceptionHandlerMethodMap();
        Set<Class<?>> exceptionClasses = exceptionHandlerMethodMap.keySet();
        EzyClassTree exceptionTree = new EzyClassTree(exceptionClasses);
        for (Class exceptionClass : exceptionTree.toList()) {
            ExceptionHandlerMethod m = exceptionHandlerMethodMap.get(exceptionClass);
            EzyInstruction instructionIf = new EzyInstruction("\t", "\n", false).append("if (arg1 instanceof ").append(exceptionClass.getName()).append(") {");
            body.append(instructionIf);
            EzyInstruction instructionHandle = new EzyInstruction("\t\t", "\n");
            Class<?> returnType = m.getReturnType();
            if (returnType != Void.TYPE) {
                instructionHandle.answer();
            }
            instructionHandle.append("this.controller.").append(m.getName()).bracketopen();
            this.appendHandleExceptionMethodArguments(m, instructionHandle, exceptionClass);
            instructionHandle.bracketclose();
            body.append(instructionHandle);
            if (returnType == Void.TYPE) {
                body.append(new EzyInstruction("\t\t", "\n").append("return null"));
            }
            body.append(new EzyInstruction("\t", "\n", false).append("}"));
        }
        body.append(new EzyInstruction("\t", "\n").append("throw arg1"));
        return function.toString();
    }

    protected String makeGetHttpMethodMethodContent() {
        HttpMethod httpMethod = ((RequestHandlerMethod)this.handlerMethod).getHttpMethod();
        return new EzyFunction(this.getGetHttpMethodMethod()).body().append(new EzyInstruction("\t", "\n").answer().append(httpMethod.getDeclaringClass().getName()).dot().append((Object)httpMethod)).function().toString();
    }

    protected String makeGetRequestURIMethodContent() {
        String requestURI = ((RequestHandlerMethod)this.handlerMethod).getRequestURI();
        if (this.requestURIDecorator != null) {
            requestURI = this.requestURIDecorator.decorate(this.controller.getClazz(), requestURI);
        }
        return new EzyFunction(this.getGetRequestURIMethod()).body().append(new EzyInstruction("\t", "\n").answer().string(requestURI)).function().toString();
    }

    protected String makeGetResponseContentTypeMethodContent() {
        return new EzyFunction(this.getGetResponseContentTypeMethod()).body().append(new EzyInstruction("\t", "\n").answer().string(((RequestHandlerMethod)this.handlerMethod).getResponseType())).function().toString();
    }

    protected String makeIsAsyncMethodContent() {
        return new EzyFunction(this.getIsAsyncMethod()).body().append(new EzyInstruction("\t", "\n").answer().append((Object)this.isAsync)).function().toString();
    }

    protected Class<?> getGenericType(Parameter parameter) {
        Type parameterizedType = parameter.getParameterizedType();
        if (parameterizedType instanceof ParameterizedType) {
            ParameterizedType argumentType = (ParameterizedType)parameterizedType;
            Type[] parameterArgTypes = argumentType.getActualTypeArguments();
            return (Class)parameterArgTypes[0];
        }
        return null;
    }

    protected EzyMethod getSetControllerMethod() {
        Method method = EzyMethods.getMethod(AbstractRequestHandler.class, (String)"setController", (Class[])new Class[]{Object.class});
        return new EzyMethod(method);
    }

    protected EzyMethod getHandleRequestMethod() {
        Method method = EzyMethods.getMethod(AbstractRequestHandler.class, (String)"handleRequest", (Class[])new Class[]{RequestArguments.class});
        return new EzyMethod(method);
    }

    protected EzyMethod getHandleExceptionMethod() {
        Method method = EzyMethods.getMethod(AbstractRequestHandler.class, (String)"handleException", (Class[])new Class[]{RequestArguments.class, Exception.class});
        return new EzyMethod(method);
    }

    protected EzyMethod getGetHttpMethodMethod() {
        Method method = EzyMethods.getMethod(AbstractRequestHandler.class, (String)"getMethod", (Class[])new Class[0]);
        return new EzyMethod(method);
    }

    protected EzyMethod getGetRequestURIMethod() {
        Method method = EzyMethods.getMethod(AbstractRequestHandler.class, (String)"getRequestURI", (Class[])new Class[0]);
        return new EzyMethod(method);
    }

    protected EzyMethod getGetResponseContentTypeMethod() {
        Method method = EzyMethods.getMethod(AbstractRequestHandler.class, (String)"getResponseContentType", (Class[])new Class[0]);
        return new EzyMethod(method);
    }

    protected EzyMethod getIsAsyncMethod() {
        Method method = EzyMethods.getMethod(AbstractRequestHandler.class, (String)"isAsync", (Class[])new Class[0]);
        return new EzyMethod(method);
    }

    protected Class<?> getSuperClass() {
        return AbstractRequestHandler.class;
    }

    protected String getImplClassName() {
        return this.controller.getControllerName() + "$" + ((RequestHandlerMethod)this.handlerMethod).getName() + "$Handler$AutoImpl$" + COUNT.incrementAndGet();
    }

    protected void printComponentContent(String componentContent) {
        if (debug) {
            this.logger.debug("component content: \n{}", (Object)componentContent);
        }
    }

    @Generated
    public static void setDebug(boolean debug) {
        RequestHandlerImplementer.debug = debug;
    }

    @Generated
    public void setRequestURIDecorator(RequestURIDecorator requestURIDecorator) {
        this.requestURIDecorator = requestURIDecorator;
    }

    static {
        COUNT = new AtomicInteger(0);
    }
}

