/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.reflect;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.annotation.EzyManagement;
import com.tvd12.ezyfox.annotation.EzyPayment;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyhttp.server.core.annotation.Annotations;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Authenticatable;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.TryCatch;
import com.tvd12.ezyhttp.server.core.handler.ApiController;
import com.tvd12.ezyhttp.server.core.handler.AuthenticatableController;
import com.tvd12.ezyhttp.server.core.handler.AuthenticatedController;
import com.tvd12.ezyhttp.server.core.handler.FeatureController;
import com.tvd12.ezyhttp.server.core.handler.ManageableController;
import com.tvd12.ezyhttp.server.core.handler.ManagementController;
import com.tvd12.ezyhttp.server.core.handler.PaymentController;
import com.tvd12.ezyhttp.server.core.reflect.ExceptionHandlerMethod;
import com.tvd12.ezyhttp.server.core.reflect.RequestHandlerMethod;
import com.tvd12.ezyhttp.server.core.util.ControllerAnnotations;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ControllerProxy {
    protected final EzyClass clazz;
    protected final Object instance;
    protected final String requestURI;
    protected final List<RequestHandlerMethod> requestHandlerMethods;
    protected final List<ExceptionHandlerMethod> exceptionHandlerMethods;
    protected final Map<Class<?>, ExceptionHandlerMethod> exceptionHandlerMethodMap;

    public ControllerProxy(Object instance) {
        this.instance = instance;
        this.clazz = new EzyClass(instance.getClass());
        this.requestURI = this.getRequestURI();
        this.requestHandlerMethods = this.fetchRequestHandlerMethods();
        this.exceptionHandlerMethods = this.fetchExceptionHandlerMethods();
        this.exceptionHandlerMethodMap = this.fetchExceptionHandlerMethodMap();
    }

    protected String getRequestURI() {
        return ControllerAnnotations.getURI(this.instance);
    }

    protected List<RequestHandlerMethod> fetchRequestHandlerMethods() {
        ArrayList<RequestHandlerMethod> list = new ArrayList<RequestHandlerMethod>();
        List methods = this.clazz.getPublicMethods(this::isRequestHandlerMethod);
        for (EzyMethod method : methods) {
            RequestHandlerMethod m = new RequestHandlerMethod(this.requestURI, method);
            list.add(m);
        }
        return list;
    }

    public boolean isManagement() {
        boolean answer;
        boolean bl = answer = this.instance instanceof ManagementController || this.isAnnotationPresent(EzyManagement.class);
        if (!answer && this.instance instanceof ManageableController) {
            answer = ((ManageableController)this.instance).isManagement();
        }
        return answer;
    }

    public boolean isApi() {
        boolean answer = this.isAnnotationPresent(Api.class);
        if (!answer && this.instance instanceof ApiController) {
            answer = ((ApiController)this.instance).isApi();
        }
        return answer;
    }

    public boolean isAuthenticated() {
        boolean answer = this.isAnnotationPresent(Authenticated.class);
        if (!answer && this.instance instanceof AuthenticatedController) {
            answer = ((AuthenticatedController)this.instance).isAuthenticated();
        }
        return answer;
    }

    public boolean isAuthenticatable() {
        boolean answer = this.isAnnotationPresent(Authenticatable.class);
        if (!answer && this.instance instanceof AuthenticatableController) {
            answer = ((AuthenticatableController)this.instance).isAuthenticatable();
        }
        return answer;
    }

    public boolean isPayment() {
        boolean answer = this.isAnnotationPresent(EzyPayment.class);
        if (!answer && this.instance instanceof ManageableController) {
            answer = ((PaymentController)this.instance).isPayment();
        }
        return answer;
    }

    public String getFeature() {
        String answer;
        EzyFeature annotation = (EzyFeature)this.clazz.getAnnotation(EzyFeature.class);
        String string = answer = annotation != null ? annotation.value() : null;
        if (EzyStrings.isBlank((String)answer) && this.instance instanceof ManageableController) {
            answer = ((FeatureController)this.instance).getFeature();
        }
        return answer;
    }

    public List<ExceptionHandlerMethod> fetchExceptionHandlerMethods() {
        ArrayList<ExceptionHandlerMethod> list = new ArrayList<ExceptionHandlerMethod>();
        List methods = this.clazz.getMethods(m -> m.isAnnotated(TryCatch.class));
        for (EzyMethod method : methods) {
            ExceptionHandlerMethod m2 = new ExceptionHandlerMethod(method);
            list.add(m2);
        }
        return list;
    }

    protected final Map<Class<?>, ExceptionHandlerMethod> fetchExceptionHandlerMethodMap() {
        HashMap answer = new HashMap();
        for (ExceptionHandlerMethod m : this.exceptionHandlerMethods) {
            for (Class<?> exceptionClass : m.getExceptionClasses()) {
                answer.put(exceptionClass, m);
            }
        }
        return answer;
    }

    protected boolean isRequestHandlerMethod(EzyMethod method) {
        for (Class<?> annClass : Annotations.REQUEST_HANDLER_ANNOTATIONS) {
            Annotation annotation = method.getAnnotation(annClass);
            if (annotation == null) continue;
            return true;
        }
        return false;
    }

    public String getControllerName() {
        return this.clazz.getClazz().getSimpleName();
    }

    private boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return EzyClasses.isAnnotationPresentIncludeSuper((Class)this.clazz.getClazz(), annotationClass);
    }

    public String toString() {
        return this.clazz.getName() + "(\n\tinstance: " + this.instance + ",\n\trequestHandlerMethods: " + this.requestHandlerMethods + ",\n\texceptionHandlerMethods: " + this.exceptionHandlerMethods + "\n)";
    }

    @Generated
    public EzyClass getClazz() {
        return this.clazz;
    }

    @Generated
    public Object getInstance() {
        return this.instance;
    }

    @Generated
    public List<RequestHandlerMethod> getRequestHandlerMethods() {
        return this.requestHandlerMethods;
    }

    @Generated
    public List<ExceptionHandlerMethod> getExceptionHandlerMethods() {
        return this.exceptionHandlerMethods;
    }

    @Generated
    public Map<Class<?>, ExceptionHandlerMethod> getExceptionHandlerMethodMap() {
        return this.exceptionHandlerMethodMap;
    }
}

