/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.jackson;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyArrayList;
import com.tvd12.ezyfox.entity.EzyHashMap;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.entity.EzyRoArray;
import com.tvd12.ezyfox.entity.EzyRoObject;
import com.tvd12.ezyfox.jackson.JacksonArraySerializer;
import com.tvd12.ezyfox.jackson.JacksonDateSerializer;
import com.tvd12.ezyfox.jackson.JacksonInstantSerializer;
import com.tvd12.ezyfox.jackson.JacksonLocalDateSerializer;
import com.tvd12.ezyfox.jackson.JacksonLocalDateTimeSerializer;
import com.tvd12.ezyfox.jackson.JacksonLocalTimeSerializer;
import com.tvd12.ezyfox.jackson.JacksonObjectSerializer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;

public class JacksonObjectMapperBuilder
implements EzyBuilder<ObjectMapper> {
    public static JacksonObjectMapperBuilder newInstance() {
        return new JacksonObjectMapperBuilder();
    }

    public ObjectMapper build() {
        return new ObjectMapper().registerModule(this.newModule());
    }

    protected Module newModule() {
        JacksonArraySerializer arraySerializer = new JacksonArraySerializer();
        JacksonObjectSerializer objectSerializer = new JacksonObjectSerializer();
        SimpleModule module = new SimpleModule();
        module.addSerializer(EzyRoArray.class, (JsonSerializer)arraySerializer);
        module.addSerializer(EzyArray.class, (JsonSerializer)arraySerializer);
        module.addSerializer(EzyArrayList.class, (JsonSerializer)arraySerializer);
        module.addSerializer(EzyRoObject.class, (JsonSerializer)objectSerializer);
        module.addSerializer(EzyObject.class, (JsonSerializer)objectSerializer);
        module.addSerializer(EzyHashMap.class, (JsonSerializer)objectSerializer);
        module.addSerializer(Date.class, (JsonSerializer)new JacksonDateSerializer());
        module.addSerializer(Instant.class, (JsonSerializer)new JacksonInstantSerializer());
        module.addSerializer(LocalDate.class, (JsonSerializer)new JacksonLocalDateSerializer());
        module.addSerializer(LocalTime.class, (JsonSerializer)new JacksonLocalTimeSerializer());
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new JacksonLocalDateTimeSerializer());
        return module;
    }
}

