/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.reflections.util;

import com.tvd12.reflections.Configuration;
import com.tvd12.reflections.Reflections;
import com.tvd12.reflections.ReflectionsException;
import com.tvd12.reflections.adapters.JavaReflectionAdapter;
import com.tvd12.reflections.adapters.JavassistAdapter;
import com.tvd12.reflections.adapters.MetadataAdapter;
import com.tvd12.reflections.concurrent.ThreadFactoryBuilder;
import com.tvd12.reflections.scanners.Scanner;
import com.tvd12.reflections.scanners.SubTypesScanner;
import com.tvd12.reflections.scanners.TypeAnnotationsScanner;
import com.tvd12.reflections.serializers.Serializer;
import com.tvd12.reflections.serializers.XmlSerializer;
import com.tvd12.reflections.util.ClasspathHelper;
import com.tvd12.reflections.util.FilterBuilder;
import com.tvd12.reflections.util.Lists;
import com.tvd12.reflections.util.ObjectArrays;
import com.tvd12.reflections.util.Sets;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConfigurationBuilder
implements Configuration {
    @Nonnull
    private Set<Scanner> scanners = Sets.newHashSet(new TypeAnnotationsScanner(), new SubTypesScanner());
    @Nonnull
    private Set<URL> urls = Sets.newHashSet(new URL[0]);
    protected MetadataAdapter metadataAdapter;
    @Nullable
    private Predicate<String> inputsFilter;
    private Serializer serializer;
    @Nullable
    private ExecutorService executorService;
    @Nullable
    private ClassLoader[] classLoaders;
    private boolean expandSuperTypes = true;

    public static ConfigurationBuilder build(Object ... params) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        List<Object> parameters = Lists.newArrayList(new Object[0]);
        if (params != null) {
            for (Object param : params) {
                if (param == null) continue;
                if (param.getClass().isArray()) {
                    for (Object p : (Object[])param) {
                        if (p == null) continue;
                        parameters.add(p);
                    }
                    continue;
                }
                if (param instanceof Iterable) {
                    for (Object e : (Iterable)param) {
                        if (e == null) continue;
                        parameters.add(e);
                    }
                    continue;
                }
                parameters.add(param);
            }
        }
        List<ClassLoader> loaders = Lists.newArrayList(new ClassLoader[0]);
        for (Object param : parameters) {
            if (!(param instanceof ClassLoader)) continue;
            loaders.add((ClassLoader)param);
        }
        ClassLoader[] classLoaders = loaders.isEmpty() ? null : loaders.toArray(new ClassLoader[loaders.size()]);
        FilterBuilder filter = new FilterBuilder();
        List<Scanner> scanners = Lists.newArrayList(new Scanner[0]);
        for (Object e : parameters) {
            if (e instanceof String) {
                builder.addUrls(ClasspathHelper.forPackage((String)e, classLoaders));
                filter.includePackage((String)e);
                continue;
            }
            if (e instanceof Class) {
                if (Scanner.class.isAssignableFrom((Class)e)) {
                    try {
                        builder.addScanners((Scanner)((Class)e).newInstance());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                builder.addUrls(ClasspathHelper.forClass((Class)e, classLoaders));
                filter.includePackage((Class)e);
                continue;
            }
            if (e instanceof Scanner) {
                scanners.add((Scanner)e);
                continue;
            }
            if (e instanceof URL) {
                builder.addUrls((URL)e);
                continue;
            }
            if (e instanceof ClassLoader) continue;
            if (e instanceof Predicate) {
                filter.add((Predicate)e);
                continue;
            }
            if (e instanceof ExecutorService) {
                builder.setExecutorService((ExecutorService)e);
                continue;
            }
            if (Reflections.log == null) continue;
            throw new ReflectionsException("could not use param " + e);
        }
        if (builder.getUrls().isEmpty()) {
            if (classLoaders != null) {
                builder.addUrls(ClasspathHelper.forClassLoader(classLoaders));
            } else {
                builder.addUrls(ClasspathHelper.forClassLoader());
            }
        }
        builder.filterInputsBy(filter);
        if (!scanners.isEmpty()) {
            builder.setScanners(scanners.toArray(new Scanner[scanners.size()]));
        }
        if (!loaders.isEmpty()) {
            builder.addClassLoaders(loaders);
        }
        return builder;
    }

    public ConfigurationBuilder forPackages(String ... packages) {
        for (String pkg : packages) {
            this.addUrls(ClasspathHelper.forPackage(pkg, new ClassLoader[0]));
        }
        return this;
    }

    @Override
    @Nonnull
    public Set<Scanner> getScanners() {
        return this.scanners;
    }

    public ConfigurationBuilder setScanners(Scanner ... scanners) {
        this.scanners.clear();
        return this.addScanners(scanners);
    }

    public ConfigurationBuilder addScanners(Scanner ... scanners) {
        this.scanners.addAll(Sets.newHashSet(scanners));
        return this;
    }

    @Override
    @Nonnull
    public Set<URL> getUrls() {
        return this.urls;
    }

    public ConfigurationBuilder setUrls(@Nonnull Collection<URL> urls) {
        this.urls = Sets.newHashSet(urls);
        return this;
    }

    public ConfigurationBuilder setUrls(URL ... urls) {
        this.urls = Sets.newHashSet(urls);
        return this;
    }

    public ConfigurationBuilder addUrls(Collection<URL> urls) {
        this.urls.addAll(urls);
        return this;
    }

    public ConfigurationBuilder addUrls(URL ... urls) {
        this.urls.addAll(Sets.newHashSet(urls));
        return this;
    }

    @Override
    public MetadataAdapter getMetadataAdapter() {
        if (this.metadataAdapter != null) {
            return this.metadataAdapter;
        }
        try {
            this.metadataAdapter = new JavassistAdapter();
            return this.metadataAdapter;
        }
        catch (Throwable e) {
            if (Reflections.log != null) {
                Reflections.log.warn("could not create JavassistAdapter, using JavaReflectionAdapter", e);
            }
            this.metadataAdapter = new JavaReflectionAdapter();
            return this.metadataAdapter;
        }
    }

    public ConfigurationBuilder setMetadataAdapter(MetadataAdapter metadataAdapter) {
        this.metadataAdapter = metadataAdapter;
        return this;
    }

    @Override
    @Nullable
    public Predicate<String> getInputsFilter() {
        return this.inputsFilter;
    }

    public void setInputsFilter(@Nullable Predicate<String> inputsFilter) {
        this.inputsFilter = inputsFilter;
    }

    public ConfigurationBuilder filterInputsBy(Predicate<String> inputsFilter) {
        this.inputsFilter = inputsFilter;
        return this;
    }

    @Override
    @Nullable
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ConfigurationBuilder setExecutorService(@Nullable ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ConfigurationBuilder useParallelExecutor() {
        return this.useParallelExecutor(Runtime.getRuntime().availableProcessors());
    }

    public ConfigurationBuilder useParallelExecutor(int availableProcessors) {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("com.tvd12.reflections-scanner-%d").build();
        this.setExecutorService(Executors.newFixedThreadPool(availableProcessors, factory));
        return this;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer != null ? this.serializer : (this.serializer = new XmlSerializer());
    }

    public ConfigurationBuilder setSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    @Override
    @Nullable
    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    @Override
    public boolean shouldExpandSuperTypes() {
        return this.expandSuperTypes;
    }

    public ConfigurationBuilder setExpandSuperTypes(boolean expandSuperTypes) {
        this.expandSuperTypes = expandSuperTypes;
        return this;
    }

    public void setClassLoaders(@Nullable ClassLoader[] classLoaders) {
        this.classLoaders = classLoaders;
    }

    public ConfigurationBuilder addClassLoader(ClassLoader classLoader) {
        return this.addClassLoaders(classLoader);
    }

    public ConfigurationBuilder addClassLoaders(ClassLoader ... classLoaders) {
        this.classLoaders = this.classLoaders == null ? classLoaders : ObjectArrays.concat(this.classLoaders, classLoaders, ClassLoader.class);
        return this;
    }

    public ConfigurationBuilder addClassLoaders(Collection<ClassLoader> classLoaders) {
        return this.addClassLoaders(classLoaders.toArray(new ClassLoader[classLoaders.size()]));
    }
}

