/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.thymeleaf;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyhttp.core.util.Locales;
import com.tvd12.ezyhttp.server.core.view.AbsentMessageResolver;
import com.tvd12.ezyhttp.server.core.view.I18nMessageResolver;
import com.tvd12.ezyhttp.server.core.view.MessageProvider;
import com.tvd12.ezyhttp.server.core.view.MessageReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.messageresolver.IMessageResolver;

public class ThymeleafMessageResolver
implements I18nMessageResolver,
IMessageResolver {
    private final String name = "DEFAULT";
    private final Integer order = 0;
    private final String messageLocation;
    private final Properties defaultMessages;
    private final Map<Locale, Properties> messagesByLocale;
    private final Map<String, Properties> messagesByLanguage;
    private final List<MessageProvider> messageProviders;
    private final AbsentMessageResolver absentMessageResolver;
    private static final int ORDER = 0;
    private static final String NAME = "DEFAULT";
    private static final Object[] EMPTY_MESSAGE_PARAMETERS = new Object[0];

    protected ThymeleafMessageResolver(Builder builder) {
        this.messageLocation = builder.messageLocation;
        this.messageProviders = builder.messageProviders;
        this.absentMessageResolver = builder.absentMessageResolver;
        this.messagesByLanguage = this.collectMessages();
        this.messagesByLocale = this.mapMessagesToLocale();
        this.defaultMessages = this.messagesByLanguage.computeIfAbsent("", it -> new Properties());
    }

    private Map<String, Properties> collectMessages() {
        HashMap<String, Properties> answer = new HashMap<String, Properties>();
        this.mergeAnswerMessages(answer, this.readMessages());
        for (MessageProvider provider : this.messageProviders) {
            this.mergeAnswerMessages(answer, provider.provide());
        }
        return answer;
    }

    private Map<String, Properties> readMessages() {
        MessageReader messageReader = MessageReader.getDefault();
        return messageReader.read(this.messageLocation);
    }

    private void mergeAnswerMessages(Map<String, Properties> answer, Map<String, Properties> messagesMap) {
        for (String language : messagesMap.keySet()) {
            Properties messages = messagesMap.get(language);
            answer.computeIfAbsent(language, k -> new Properties()).putAll((Map<?, ?>)messages);
            answer.computeIfAbsent(language.toLowerCase(), k -> new Properties()).putAll((Map<?, ?>)messages);
        }
    }

    private Map<Locale, Properties> mapMessagesToLocale() {
        HashMap<Locale, Properties> messagesByLocale = new HashMap<Locale, Properties>();
        for (String lang : this.messagesByLanguage.keySet()) {
            if (lang.isEmpty()) continue;
            Locale locale = Locales.getLocaleFromLanguage((String)lang);
            messagesByLocale.put(locale, this.messagesByLanguage.get(lang));
        }
        return messagesByLocale;
    }

    public void putI18nMessages(Map<String, Map<String, String>> newMessagesByLanguage) {
        for (String lang : newMessagesByLanguage.keySet()) {
            Map<String, String> messages = newMessagesByLanguage.get(lang);
            this.messagesByLanguage.computeIfAbsent(lang, k -> new Properties()).putAll(messages);
            if (lang.isEmpty()) {
                this.defaultMessages.putAll(messages);
                continue;
            }
            Locale locale = Locales.getLocaleFromLanguage((String)lang);
            this.messagesByLocale.computeIfAbsent(locale, k -> new Properties()).putAll(messages);
        }
    }

    public String resolveMessage(ITemplateContext context, Class<?> origin, String key, Object[] parameters) {
        Locale locale = context.getLocale();
        return this.resolveMessage(locale, key, parameters);
    }

    public String resolveMessage(Locale locale, String key, Object[] parameters) {
        String message = null;
        Properties messages = this.messagesByLocale.get(locale);
        if (messages != null) {
            message = messages.getProperty(key);
        }
        if (message == null && (messages = this.messagesByLanguage.get(locale.getLanguage())) != null) {
            message = messages.getProperty(key);
        }
        if (message == null) {
            message = this.defaultMessages.getProperty(key);
        }
        return message != null ? this.formatMessage(locale, message, parameters) : null;
    }

    public String createAbsentMessageRepresentation(ITemplateContext context, Class<?> origin, String key, Object[] parameters) {
        return this.createAbsentMessageRepresentation(context.getLocale(), key, parameters);
    }

    public String createAbsentMessageRepresentation(Locale locale, String key, Object[] parameters) {
        String message;
        if (this.absentMessageResolver != null && (message = this.absentMessageResolver.resolve(locale, this.getClass(), key, parameters)) != null) {
            return message;
        }
        return key;
    }

    private String formatMessage(Locale locale, String message, Object[] parameters) {
        if (!ThymeleafMessageResolver.isFormatCandidate(message)) {
            return message;
        }
        MessageFormat messageFormat = new MessageFormat(message, locale);
        return messageFormat.format(parameters != null ? parameters : EMPTY_MESSAGE_PARAMETERS);
    }

    private static boolean isFormatCandidate(String message) {
        int n = message.length();
        while (n-- != 0) {
            char ch = message.charAt(n);
            if (ch != '}' && ch != '\'') continue;
            return true;
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getOrder() {
        return this.order;
    }

    public static class Builder
    implements EzyBuilder<ThymeleafMessageResolver> {
        private String messageLocation;
        private List<MessageProvider> messageProviders;
        private AbsentMessageResolver absentMessageResolver;

        public Builder messageLocation(String messageLocation) {
            this.messageLocation = messageLocation;
            return this;
        }

        public Builder messageProviders(List<MessageProvider> messageProviders) {
            this.messageProviders = messageProviders;
            return this;
        }

        public Builder absentMessageResolver(AbsentMessageResolver absentMessageResolver) {
            this.absentMessageResolver = absentMessageResolver;
            return this;
        }

        public ThymeleafMessageResolver build() {
            return new ThymeleafMessageResolver(this);
        }
    }
}

