/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import com.tvd12.ezyfox.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class EzyLists {
    private EzyLists() {
    }

    public static <T> List<T> combine(Collection<T> ... lists) {
        ArrayList<T> answer = new ArrayList<T>();
        for (Collection<T> list : lists) {
            answer.addAll(list);
        }
        return answer;
    }

    public static <I, O> List<O> newHashSetByAddAll(Collection<I> coll, Function<I, Collection<O>> trans) {
        ArrayList<O> set = new ArrayList<O>();
        for (I input : coll) {
            set.addAll(trans.apply(input));
        }
        return set;
    }

    public static <T> List<T> filter(Collection<T> coll, Predicate<T> predicate) {
        return coll.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <T> List<T> newArrayList(Collection<T> coll, Collection<T> except) {
        ArrayList<T> answer = new ArrayList<T>(coll);
        answer.removeAll(except);
        return answer;
    }

    public static <T> List<T> newArrayList(Collection<T> coll, T ... except) {
        return EzyLists.newArrayList(coll, Arrays.asList(except));
    }

    public static <I, O> List<O> newArrayList(I[] input, Function<I, O> refactor) {
        return EzyLists.newArrayList(Lists.newArrayList(input), refactor);
    }

    public static <I, O> List<O> newArrayList(Collection<I> input, Function<I, O> refactor) {
        ArrayList<O> answer = new ArrayList<O>();
        for (I value : input) {
            answer.add(refactor.apply(value));
        }
        return answer;
    }

    public static <K, V, O> List<O> newArrayList(Map<K, V> input, BiFunction<K, V, O> refactor) {
        ArrayList<O> answer = new ArrayList<O>();
        for (K key : input.keySet()) {
            answer.add(refactor.apply(key, input.get(key)));
        }
        return answer;
    }

    public static <T> List<T> addElementsToNewList(Collection<T> coll, T ... elements) {
        ArrayList<T> answer = new ArrayList<T>(coll);
        answer.addAll(Arrays.asList(elements));
        return answer;
    }

    public static <T> void resize(List<T> list, int n, T defValue) {
        int size = list.size();
        if (size == n) {
            return;
        }
        if (size > n) {
            int offset = size - n;
            while (offset-- > 0) {
                list.remove(list.size() - 1);
            }
        } else {
            int offset = n - size;
            while (offset-- > 0) {
                list.add(defValue);
            }
        }
    }

    public static <T> List<T> take(List<T> list, int limit) {
        return list.size() > limit ? list.subList(0, limit) : list;
    }

    public static <T> T first(List<T> list) {
        return list.isEmpty() ? null : (T)list.get(0);
    }

    public static <T> T first(List<T> list, T defaultValue) {
        return list.isEmpty() ? defaultValue : list.get(0);
    }

    public static <T> T last(List<T> list) {
        return list.isEmpty() ? null : (T)list.get(list.size() - 1);
    }

    public static <T> T last(List<T> list, T defaultValue) {
        return list.isEmpty() ? defaultValue : list.get(list.size() - 1);
    }
}

