/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class EzyClassTree {
    protected final List<Node> roots = new ArrayList<Node>();

    public EzyClassTree() {
    }

    public EzyClassTree(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    public EzyClassTree(Collection<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            this.add(clazz);
        }
    }

    public void add(Class<?> clazz) {
        this.add(clazz, this.roots);
    }

    private void add(Class<?> clazz, List<Node> existedNodes) {
        if (existedNodes.isEmpty()) {
            existedNodes.add(new Node((Class)clazz));
            return;
        }
        for (Node node : existedNodes) {
            if (!node.clazz.equals(clazz)) continue;
            return;
        }
        ArrayList<Node> children = new ArrayList<Node>();
        for (Node node : existedNodes) {
            if (!clazz.isAssignableFrom(node.clazz)) continue;
            children.add(node);
        }
        if (children.size() > 0) {
            Node node = new Node(clazz, children);
            existedNodes.removeAll(children);
            existedNodes.add(node);
            return;
        }
        for (Node node : existedNodes) {
            if (!node.clazz.isAssignableFrom(clazz)) continue;
            this.add(clazz, node.children);
            return;
        }
        existedNodes.add(new Node((Class)clazz));
    }

    public List<Class<?>> toList() {
        ArrayList list = new ArrayList();
        for (Node root : this.roots) {
            root.appendToList(list);
        }
        return list;
    }

    public String toString() {
        return this.roots.stream().map(Node::toString).collect(Collectors.joining("\n"));
    }

    private static class Node {
        protected final Class<?> clazz;
        protected final List<Node> children = new ArrayList<Node>();

        private Node(Class<?> clazz) {
            this.clazz = clazz;
        }

        private Node(Class<?> clazz, List<Node> children) {
            this.clazz = clazz;
            this.children.addAll(children);
        }

        private void appendToList(List<Class<?>> list) {
            for (Node child : this.children) {
                child.appendToList(list);
            }
            list.add(this.clazz);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.clazz.getName());
            if (this.children.size() > 0) {
                builder.append(" => ").append(this.children);
            }
            return builder.toString();
        }
    }
}

