/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import com.tvd12.ezyfox.collect.Lists;
import com.tvd12.ezyfox.reflect.EzyFieldFinder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EzyFields {
    private EzyFields() {
    }

    public static Object get(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't get value from field " + field.getName(), e);
        }
    }

    public static void set(Field field, Object obj, Object value) {
        try {
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't set value to field " + field.getName(), e);
        }
    }

    public static List<Field> getFields(Class clazz) {
        ArrayList<Field> answer = new ArrayList<Field>();
        for (Class currentClass = clazz; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
            Field[] fields = currentClass.getDeclaredFields();
            Collections.addAll(answer, fields);
        }
        return answer;
    }

    public static Field getField(Class clazz, String fieldName) {
        return new EzyFieldFinder(clazz, fieldName).find();
    }

    public static List<Field> getAnnotatedFields(Class clazz, Class<? extends Annotation> annClass) {
        ArrayList<Field> answer = new ArrayList<Field>();
        Class currentClass = clazz;
        while (!currentClass.equals(Object.class)) {
            Field[] fields;
            for (Field field : fields = currentClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(annClass)) continue;
                answer.add(field);
            }
            currentClass = currentClass.getSuperclass();
        }
        return answer;
    }

    public static List<Field> getDeclaredFields(Class clazz) {
        return Lists.newArrayList(clazz.getDeclaredFields());
    }

    public static String getGetterMethod(Field field) {
        Class<?> type = field.getType();
        String prefix = "get";
        if (type.equals(Boolean.TYPE)) {
            prefix = "is";
        }
        return prefix + EzyFields.getMethodSuffix(field);
    }

    public static String getSetterMethod(Field field) {
        return "set" + EzyFields.getMethodSuffix(field);
    }

    private static String getMethodSuffix(Field field) {
        String name = field.getName();
        String first = name.substring(0, 1).toUpperCase();
        return name.length() == 1 ? first : first + name.substring(1);
    }
}

