/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.collect.Lists;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyfox.reflect.EzyReflectElement;
import com.tvd12.ezyfox.util.EzyEquals;
import com.tvd12.ezyfox.util.EzyHashCodes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class EzyMethod
implements EzyReflectElement {
    protected final Method method;
    protected String displayName;

    public EzyMethod(Method method) {
        this.method = method;
        this.displayName = method.getName();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Object invoke(Object obj, Object ... args) {
        return EzyMethods.invoke(this.method, obj, args);
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    public boolean isSetter() {
        return this.isPublic() && this.method.getName().startsWith("set") && this.method.getParameterCount() == 1;
    }

    public boolean isGetter() {
        String methodName = this.method.getName();
        return this.isPublic() && (methodName.startsWith("get") || methodName.startsWith("is")) && this.method.getParameterCount() == 0 && this.method.getReturnType() != Void.TYPE;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.method.getModifiers());
    }

    public Class getReturnType() {
        return this.method.getReturnType();
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    public Parameter[] getParameters() {
        return this.method.getParameters();
    }

    public Class[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    public int getParameterCount() {
        return this.method.getParameterCount();
    }

    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annClass) {
        return this.method.getAnnotation(annClass);
    }

    @Override
    public boolean isAnnotated(Class<? extends Annotation> annClass) {
        return this.method.isAnnotationPresent(annClass);
    }

    public String getFieldName() {
        String name = this.getName();
        if (!(name.startsWith("set") || name.startsWith("get") || name.startsWith("new"))) {
            return name;
        }
        if (name.length() <= 3) {
            return name;
        }
        String remain = name.substring(3);
        return remain.substring(0, 1).toLowerCase() + remain.substring(1);
    }

    public String getDeclaration() {
        int modifiers = this.method.getModifiers();
        return this.getDeclaration(Modifier.toString(modifiers));
    }

    public String getDeclaration(String modifierName) {
        Parameter[] params = this.method.getParameters();
        Class<?> returnType = this.method.getReturnType();
        StringBuilder builder = new StringBuilder();
        builder.append(modifierName).append(" ").append(returnType.getTypeName()).append(" ").append(this.displayName).append("(");
        for (int i = 0; i < params.length; ++i) {
            builder.append(params[i].getType().getTypeName()).append(" ").append(params[i].getName());
            if (i >= params.length - 1) continue;
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }

    public String getPublicDeclaration() {
        return this.getDeclaration("public");
    }

    public void setAccessible(boolean flag) {
        this.method.setAccessible(flag);
    }

    public boolean equals(Object obj) {
        return new EzyEquals<EzyMethod>().function(m -> m.method).isEquals(this, obj);
    }

    public int hashCode() {
        return new EzyHashCodes().append(this.method).toHashCode();
    }

    public String toString() {
        return this.method.toString();
    }

    @Generated
    public Method getMethod() {
        return this.method;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public static class Builder
    implements EzyBuilder<EzyMethod> {
        protected Class clazz;
        protected String methodName;
        protected List<Class> parameterTypes = new ArrayList<Class>();

        public Builder clazz(Class clazz) {
            this.clazz = clazz;
            return this;
        }

        public Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder parameterTypes(Class ... parameterTypes) {
            this.parameterTypes.addAll(Lists.newArrayList(parameterTypes));
            return this;
        }

        @Override
        public EzyMethod build() {
            return new EzyMethod(this.getMethod());
        }

        protected Method getMethod() {
            return EzyMethods.getMethod(this.clazz, this.methodName, this.getParameterTypes());
        }

        protected Class[] getParameterTypes() {
            return this.parameterTypes.toArray(new Class[0]);
        }
    }
}

