/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.stream;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.io.EzyClassesFetcher;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.stream.EzyAnywayInputStreamLoader;
import com.tvd12.ezyfox.stream.EzyInputStreamLoader;
import com.tvd12.ezyfox.stream.EzyInputStreamReader;
import com.tvd12.ezyfox.stream.EzySimpleInputStreamReader;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EzyStreamClassesFetcher
implements EzyClassesFetcher {
    protected final ClassLoader classLoader;

    public EzyStreamClassesFetcher() {
        this(EzyStreamClassesFetcher.builder());
    }

    protected EzyStreamClassesFetcher(Builder builder) {
        this.classLoader = builder.classLoader;
    }

    @Override
    public Set<Class> asSet(String filePath) {
        return new HashSet<Class>(this.asList(filePath));
    }

    @Override
    public List<Class> asList(String filePath) {
        Collection<String> classNames = this.getClassNames(filePath);
        return EzyLists.newArrayList(classNames, this::getClass);
    }

    protected Class getClass(String className) {
        return EzyClasses.getClass((String)className, (ClassLoader)this.classLoader);
    }

    protected Collection<String> getClassNames(String filePath) {
        InputStream stream = this.loadInputStream(filePath);
        EzyInputStreamReader reader = this.newInputStreamReader();
        return reader.readLines(stream, "UTF-8");
    }

    protected EzyInputStreamReader newInputStreamReader() {
        return new EzySimpleInputStreamReader.Builder().build();
    }

    protected InputStream loadInputStream(String filePath) {
        EzyInputStreamLoader loader = this.newInputStreamLoader();
        return loader.load(filePath);
    }

    protected EzyInputStreamLoader newInputStreamLoader() {
        return new EzyAnywayInputStreamLoader.Builder().classLoader(this.classLoader).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements EzyBuilder<EzyClassesFetcher> {
        protected ClassLoader classLoader = this.getClass().getClassLoader();

        public Builder context(Class<?> context) {
            return this.classLoader(context.getClassLoader());
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public EzyClassesFetcher build() {
            return new EzyStreamClassesFetcher(this);
        }
    }
}

