/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ReflectionClassUtil {
    private ReflectionClassUtil() {
    }

    public static Object newInstance(Class<?> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create instance of classes: " + clazz.getName(), e);
        }
    }

    public static Object newInstance(Constructor<?> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create instance of constructor: " + constructor, e);
        }
    }

    public static Set<Field> getValidFields(Class<?> clazz) {
        HashSet<Field> answer = new HashSet<Field>();
        for (Class<?> current = clazz; current != Object.class; current = current.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = current.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if ((modifiers & 8) != 0) continue;
                answer.add(field);
            }
        }
        return answer;
    }

    public static Set<Field> getFieldsWithAnnotations(Class<?> clazz, List<Class> annotationClasses) {
        HashSet<Field> answer = new HashSet<Field>();
        for (Class annotationClass : annotationClasses) {
            answer.addAll(ReflectionClassUtil.getFieldsWithAnnotation(clazz, annotationClass));
        }
        return answer;
    }

    public static Set<Field> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        HashSet<Class> allClasses = new HashSet<Class>();
        Set<Class> superClasses = ReflectionClassUtil.flatSuperClasses(clazz);
        allClasses.add(clazz);
        allClasses.addAll(superClasses);
        HashSet<Field> answer = new HashSet<Field>();
        for (Class item : allClasses) {
            Field[] fields;
            for (Field field : fields = item.getDeclaredFields()) {
                if (!field.isAnnotationPresent(annotationClass)) continue;
                answer.add(field);
            }
        }
        return answer;
    }

    public static Set<Method> getPublicMethods(Class<?> clazz) {
        HashSet<Method> answer = new HashSet<Method>();
        for (Class<?> current = clazz; current != Object.class; current = current.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = current.getDeclaredMethods()) {
                int modifiers = method.getModifiers();
                if ((modifiers & 1) == 0 || (modifiers & 0x400) != 0) continue;
                answer.add(method);
            }
        }
        return answer;
    }

    public static Set<Method> getMethodsWithAnnotations(Class<?> clazz, List<Class> annotationClasses) {
        HashSet<Method> answer = new HashSet<Method>();
        for (Class annotationClass : annotationClasses) {
            answer.addAll(ReflectionClassUtil.getMethodsWithAnnotation(clazz, annotationClass));
        }
        return answer;
    }

    public static Set<Method> getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        HashSet<Class> allClasses = new HashSet<Class>();
        Set<Class> superAndInterfaceClasses = ReflectionClassUtil.flatSuperAndInterfaceClasses(clazz);
        allClasses.add(clazz);
        allClasses.addAll(superAndInterfaceClasses);
        HashSet<Method> answer = new HashSet<Method>();
        for (Class item : allClasses) {
            Method[] methods;
            for (Method method : methods = item.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(annotationClass)) continue;
                answer.add(method);
            }
        }
        return answer;
    }

    public static Set<Class> flatSuperClasses(Class clazz) {
        return ReflectionClassUtil.flatSuperClasses(clazz, false);
    }

    public static Set<Class> flatSuperClasses(Class clazz, boolean includeObject) {
        HashSet<Class> classes = new HashSet<Class>();
        for (Class superClass = clazz.getSuperclass(); superClass != null && (!superClass.equals(Object.class) || includeObject); superClass = superClass.getSuperclass()) {
            classes.add(superClass);
        }
        return classes;
    }

    public static Set<Class> flatInterfaces(Class clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        HashSet<Class> classes = new HashSet<Class>(Arrays.asList(interfaces));
        for (Class<?> itf : interfaces) {
            classes.addAll(ReflectionClassUtil.flatInterfaces(itf));
        }
        return classes;
    }

    public static Set<Class> flatSuperAndInterfaceClasses(Class clazz) {
        return ReflectionClassUtil.flatSuperAndInterfaceClasses(clazz, false);
    }

    public static Set<Class> flatSuperAndInterfaceClasses(Class clazz, boolean includeObject) {
        Set<Class> interfaces = ReflectionClassUtil.flatInterfaces(clazz);
        Set<Class> superClasses = ReflectionClassUtil.flatSuperClasses(clazz, includeObject);
        HashSet<Class> classes = new HashSet<Class>(interfaces);
        for (Class superClass : superClasses) {
            Set<Class> superAndInterfaceClasses = ReflectionClassUtil.flatSuperAndInterfaceClasses(superClass, includeObject);
            classes.add(superClass);
            classes.addAll(superAndInterfaceClasses);
        }
        return classes;
    }

    public static Constructor getNoArgsDeclaredConstructor(Class clazz) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    public static Constructor getMaxArgsDeclaredConstructor(Class clazz) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        Constructor<?> max = constructors[0];
        for (int i = 1; i < constructors.length; ++i) {
            if (constructors[i].getParameterCount() <= max.getParameterCount()) continue;
            max = constructors[i];
        }
        return max;
    }
}

