/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.manager;

import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RequestURIManager
implements EzyDestroyable {
    private final Map<HttpMethod, Set<String>> apiURIs = new ConcurrentHashMap<HttpMethod, Set<String>>();
    private final Map<HttpMethod, Set<String>> authenticatedURIs = new ConcurrentHashMap<HttpMethod, Set<String>>();
    private final Map<HttpMethod, Set<String>> authenticatableURIs = new ConcurrentHashMap<HttpMethod, Set<String>>();
    private final Map<HttpMethod, Set<String>> handledURIs = new ConcurrentHashMap<HttpMethod, Set<String>>();
    private final Map<HttpMethod, Set<String>> managementURIs = new ConcurrentHashMap<HttpMethod, Set<String>>();
    private final Map<HttpMethod, Set<String>> paymentURIs = new ConcurrentHashMap<HttpMethod, Set<String>>();

    public void addHandledURI(HttpMethod method, String uri) {
        this.handledURIs.computeIfAbsent(method, k -> ConcurrentHashMap.newKeySet()).add(uri);
    }

    public boolean containsHandledURI(HttpMethod method, String uri) {
        Set<String> uris = this.handledURIs.get(method);
        return uris != null && uris.contains(uri);
    }

    public void addApiURI(HttpMethod method, String uri) {
        this.apiURIs.computeIfAbsent(method, k -> ConcurrentHashMap.newKeySet()).add(uri);
    }

    public boolean isApiURI(HttpMethod method, String uri) {
        Set<String> uris = this.apiURIs.get(method);
        return uris != null && uris.contains(uri);
    }

    public void addManagementURI(HttpMethod method, String uri) {
        this.managementURIs.computeIfAbsent(method, k -> ConcurrentHashMap.newKeySet()).add(uri);
    }

    public boolean isManagementURI(HttpMethod method, String uri) {
        Set<String> uris = this.managementURIs.get(method);
        return uris != null && uris.contains(uri);
    }

    public void addAuthenticatedURI(HttpMethod method, String uri) {
        this.authenticatedURIs.computeIfAbsent(method, k -> ConcurrentHashMap.newKeySet()).add(uri);
    }

    public boolean isAuthenticatedURI(HttpMethod method, String uri) {
        Set<String> uris = this.authenticatedURIs.get(method);
        return uris != null && uris.contains(uri);
    }

    public void addAuthenticatableURI(HttpMethod method, String uri) {
        this.authenticatableURIs.computeIfAbsent(method, k -> ConcurrentHashMap.newKeySet()).add(uri);
    }

    public boolean isAuthenticatableURI(HttpMethod method, String uri) {
        Set<String> uris = this.authenticatableURIs.get(method);
        return uris != null && uris.contains(uri);
    }

    public void addPaymentURI(HttpMethod method, String uri) {
        this.paymentURIs.computeIfAbsent(method, k -> ConcurrentHashMap.newKeySet()).add(uri);
    }

    public boolean isPaymentURI(HttpMethod method, String uri) {
        Set<String> uris = this.paymentURIs.get(method);
        return uris != null && uris.contains(uri);
    }

    public List<String> getHandledURIs(HttpMethod method) {
        Set<String> uris = this.handledURIs.get(method);
        return uris != null ? new ArrayList<String>(uris) : Collections.emptyList();
    }

    public List<String> getApiURIs(HttpMethod method) {
        Set<String> uris = this.apiURIs.get(method);
        return uris != null ? new ArrayList<String>(uris) : Collections.emptyList();
    }

    public List<String> getAuthenticatedURIs(HttpMethod method) {
        Set<String> uris = this.authenticatedURIs.get(method);
        return uris != null ? new ArrayList<String>(uris) : Collections.emptyList();
    }

    public List<String> getManagementURIs(HttpMethod method) {
        Set<String> uris = this.managementURIs.get(method);
        return uris != null ? new ArrayList<String>(uris) : Collections.emptyList();
    }

    public List<String> getPaymentURIs(HttpMethod method) {
        Set<String> uris = this.paymentURIs.get(method);
        return uris != null ? new ArrayList<String>(uris) : Collections.emptyList();
    }

    public void destroy() {
        this.handledURIs.clear();
        this.managementURIs.clear();
        this.authenticatedURIs.clear();
    }
}

