/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.mapping;

import com.tvd12.properties.file.annotation.PropertyAnnotation;
import com.tvd12.properties.file.annotation.PropertyAnnotations;
import com.tvd12.properties.file.exception.PropertiesFileException;
import com.tvd12.properties.file.io.ValueConverter;
import com.tvd12.properties.file.mapping.MappingLevel;
import com.tvd12.properties.file.reader.BaseFileReader;
import com.tvd12.properties.file.reader.FileReader;
import com.tvd12.properties.file.struct.PropertiesBean;
import com.tvd12.properties.file.util.PropertiesUtil;
import com.tvd12.properties.file.util.ReflectionGenericUtil;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PropertiesMapper {
    private Object bean;
    private Class<?> clazz;
    private Properties properties;
    private String propertiesFile;
    private FileReader reader;
    private ClassLoader classLoader;
    private String propertyPrefix;
    private MappingLevel mappingLevel = MappingLevel.ALL;
    private ValueConverter valueConverter;
    private PropertyAnnotations propertyAnnotations;

    public PropertiesMapper clazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public PropertiesMapper context(Class<?> context) {
        return this.classLoader(context.getClassLoader());
    }

    public PropertiesMapper classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public PropertiesMapper bean(Object bean) {
        this.bean = bean;
        return this;
    }

    public PropertiesMapper data(Properties properties) {
        this.properties = properties;
        return this;
    }

    public PropertiesMapper data(Map map) {
        this.properties = PropertiesUtil.toProperties(map);
        return this;
    }

    public PropertiesMapper propertyPrefix(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
        return this;
    }

    public PropertiesMapper mappingLevel(MappingLevel mappingLevel) {
        this.mappingLevel = mappingLevel;
        return this;
    }

    public PropertiesMapper addPropertyAnnotation(PropertyAnnotation annotation) {
        if (this.propertyAnnotations == null) {
            this.propertyAnnotations = new PropertyAnnotations();
        }
        this.propertyAnnotations.addPropertyAnnotation(annotation);
        return this;
    }

    public PropertiesMapper propertyAnnotations(PropertyAnnotations propertyAnnotations) {
        this.propertyAnnotations = propertyAnnotations;
        return this;
    }

    public PropertiesMapper file(String propertiesFilePath) {
        this.propertiesFile = propertiesFilePath;
        return this;
    }

    public PropertiesMapper reader(FileReader reader) {
        this.reader = reader;
        return this;
    }

    public PropertiesMapper valueConverter(ValueConverter valueConverter) {
        this.valueConverter = valueConverter;
        return this;
    }

    public <T> T map() {
        if (this.bean == null && this.clazz == null) {
            this.clazz = Properties.class;
        }
        return (T)this.map(this.clazz);
    }

    public <T> T map(Class<T> clazz) {
        return this.map(clazz, null);
    }

    public <T> T map(Class<T> clazz, Type genericType) {
        if (clazz == null && this.bean == null) {
            throw new IllegalArgumentException("there is nothing to map, plase provice clazz, or bean");
        }
        this.clazz(clazz);
        this.readProperties();
        if (this.propertyAnnotations == null) {
            this.propertyAnnotations = new PropertyAnnotations();
        }
        if (clazz == Map.class) {
            return (T)this.doMapToMapValue(genericType);
        }
        if (clazz == Properties.class) {
            return (T)this.properties;
        }
        return (T)this.doMapValue();
    }

    private <T> T map(PropertiesBean mapping) {
        mapping.putAll(this.properties);
        return mapping.getObject();
    }

    private Object doMapValue() {
        if (this.bean != null) {
            return this.map(new PropertiesBean(this.bean, this.mappingLevel, this.valueConverter, this.propertyAnnotations, this.classLoader));
        }
        return this.map(new PropertiesBean(this.clazz, this.properties, this.mappingLevel, this.valueConverter, this.propertyAnnotations, this.classLoader));
    }

    private Map doMapToMapValue(Type genericType) {
        if (genericType == null) {
            return this.properties;
        }
        Class mapValueType = ReflectionGenericUtil.getTwoGenericClassArguments(genericType)[1];
        if (mapValueType == null) {
            return this.properties;
        }
        HashMap answer = new HashMap();
        Map<String, Properties> propertiesMap = PropertiesUtil.getPropertiesMap(this.properties);
        for (String key : propertiesMap.keySet()) {
            Object value = new PropertiesMapper().data(this.properties).propertyPrefix(key).classLoader(this.classLoader).valueConverter(this.valueConverter).propertyAnnotations(this.propertyAnnotations).map(mapValueType);
            answer.put(key, value);
        }
        return answer;
    }

    private void readProperties() {
        try {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            if (this.propertiesFile != null) {
                if (this.reader == null) {
                    this.reader = new BaseFileReader();
                }
                this.properties.putAll((Map<?, ?>)this.reader.read(this.classLoader, this.propertiesFile));
            }
            if (this.propertyPrefix != null) {
                this.properties = PropertiesUtil.getPropertiesByPrefix(this.properties, this.propertyPrefix);
            }
        }
        catch (PropertiesFileException e) {
            throw new IllegalStateException(e);
        }
        PropertiesUtil.decorateProperties(this.properties);
    }
}

