/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.entity;

import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyTransformable;
import com.tvd12.ezyfox.exception.EzyArrayGetException;
import com.tvd12.ezyfox.io.EzyCollectionConverter;
import com.tvd12.ezyfox.io.EzyInputTransformer;
import com.tvd12.ezyfox.io.EzyOutputTransformer;
import com.tvd12.ezyfox.util.EzyArrayToList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class EzyArrayList
extends EzyTransformable
implements EzyArray {
    private static final long serialVersionUID = 5952111146742741007L;
    protected final ArrayList<Object> list = new ArrayList();
    protected final EzyCollectionConverter collectionConverter;

    public EzyArrayList(EzyInputTransformer inputTransformer, EzyOutputTransformer outputTransformer, EzyCollectionConverter collectionConverter) {
        super(inputTransformer, outputTransformer);
        this.collectionConverter = collectionConverter;
    }

    public EzyArrayList(Collection items, EzyInputTransformer inputTransformer, EzyOutputTransformer outputTransformer, EzyCollectionConverter collectionConverter) {
        this(inputTransformer, outputTransformer, collectionConverter);
        this.list.addAll(items);
    }

    @Override
    public <T> T get(int index) {
        return (T)this.list.get(index);
    }

    @Override
    public <T> T get(int index, Class<T> type) {
        return (T)this.getValue(index, type);
    }

    @Override
    public Object getValue(int index, Class type) {
        Object value = this.list.get(index);
        try {
            return this.transformOutput(value, type);
        }
        catch (Exception e) {
            throw new EzyArrayGetException(index, value, type, e);
        }
    }

    @Override
    public boolean isNotNullValue(int index) {
        boolean answer = false;
        int size = this.size();
        if (index < size) {
            answer = this.list.get(index) != null;
        }
        return answer;
    }

    @Override
    public boolean contains(Object value) {
        return this.list.contains(value);
    }

    @Override
    public boolean containsAll(Collection values) {
        return this.list.containsAll(values);
    }

    @Override
    public EzyArray sub(int fromIndex, int toIndex) {
        List<Object> subList = this.list.subList(fromIndex, toIndex);
        return new EzyArrayList(subList, this.inputTransformer, this.outputTransformer, this.collectionConverter);
    }

    @Override
    public void add(Object item) {
        this.list.add(this.transformInput(item));
    }

    @Override
    public void add(Object ... items) {
        for (Object item : items) {
            this.add(item);
        }
    }

    @Override
    public void add(Collection items) {
        for (Object item : items) {
            this.add(item);
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public <T> T set(int index, Object item) {
        return (T)this.list.set(index, this.transformInput(item));
    }

    @Override
    public <T> T remove(int index) {
        return (T)this.list.remove(index);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public void sort(Comparator comparator) {
        this.list.sort(comparator);
    }

    @Override
    public void forEach(Consumer<Object> action) {
        this.list.forEach(action);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.list.iterator();
    }

    public List toList() {
        EzyArrayToList arrayToList = EzyArrayToList.getInstance();
        return arrayToList.toList(this);
    }

    @Override
    public <T> List<T> toList(Class<T> type) {
        return this.toList();
    }

    @Override
    public <T, A> A toArray(Class<T> type) {
        return (A)this.collectionConverter.toArray(this.list, type);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Collection listClone = (Collection)this.list.clone();
        return new EzyArrayList(listClone, this.inputTransformer, this.outputTransformer, this.collectionConverter);
    }

    @Override
    public EzyArray duplicate() {
        try {
            return (EzyArray)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int compareTo(EzyArray o) {
        EzyArrayList other = (EzyArrayList)o;
        int result = this.list.size() - other.list.size();
        if (result != 0) {
            return result;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            Object value = this.list.get(i);
            Object otherValue = other.list.get(i);
            if (value == null) {
                if (otherValue == null) continue;
                return -1;
            }
            if (otherValue == null) {
                return 1;
            }
            if (value instanceof Comparable && otherValue instanceof Comparable) {
                result = ((Comparable)value).compareTo(otherValue);
                if (result == 0) continue;
                return result;
            }
            if (!(value instanceof Comparable)) {
                throw new IllegalArgumentException("value: " + value.getClass().getName() + "(" + value + ") is not comparable");
            }
            throw new IllegalArgumentException("value: " + otherValue.getClass().getName() + "(" + otherValue + ") is not comparable");
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        EzyArrayList t = (EzyArrayList)other;
        return t.list.equals(this.list);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    protected Object transformInput(Object input) {
        return this.inputTransformer.transform(input);
    }

    private Object transformOutput(Object output, Class type) {
        return this.outputTransformer.transform(output, type);
    }

    public String toString() {
        return this.list.toString();
    }
}

