/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.pattern;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.concurrent.EzyExecutors;
import com.tvd12.ezyfox.exception.EzyNotImplementedException;
import com.tvd12.ezyfox.pattern.EzyObjectFactory;
import com.tvd12.ezyfox.util.EzyDestroyable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfox.util.EzyStartable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class EzyObjectProvider<T>
extends EzyLoggable
implements EzyStartable,
EzyDestroyable {
    protected final long validationDelay;
    protected final long validationInterval;
    protected final Set<T> providedObjects;
    protected final EzyObjectFactory<T> objectFactory;
    protected final ScheduledExecutorService validationService;
    protected final Lock lock = new ReentrantLock();

    protected EzyObjectProvider(Builder builder) {
        this.objectFactory = builder.getObjectFactory();
        this.validationDelay = builder.validationDelay;
        this.validationInterval = builder.validationInterval;
        this.validationService = builder.getValidationService();
        this.providedObjects = this.newProvidedObjects();
    }

    protected Set<T> newProvidedObjects() {
        return Collections.synchronizedSet(new HashSet());
    }

    protected T createObject() {
        return this.objectFactory.newProduct();
    }

    protected List<T> getProvidedObjects() {
        return new ArrayList<T>(this.providedObjects);
    }

    public void start() throws Exception {
        this.startValidationService();
    }

    protected void startValidationService() {
        ArrayList buffer = new ArrayList();
        this.validationService.scheduleWithFixedDelay(this.newValidationTask(buffer), this.validationDelay, this.validationInterval, TimeUnit.MILLISECONDS);
    }

    protected Runnable newValidationTask(List<T> buffer) {
        return () -> {
            try {
                buffer.addAll(this.providedObjects);
                this.removeStaleObjects(buffer);
            }
            catch (Exception e) {
                this.logger.error("object provider validation error", (Throwable)e);
            }
            finally {
                buffer.clear();
            }
        };
    }

    protected void removeStaleObjects(List<T> buffer) {
    }

    protected final T provideObject() {
        return this.provideObject0();
    }

    private T provideObject0() {
        T object = this.createObject();
        this.providedObjects.add(object);
        return object;
    }

    public void destroy() {
        try {
            this.clearAll();
            this.shutdownAll();
        }
        catch (Exception e) {
            this.logger.error("{} error", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)e);
        }
    }

    protected void clearAll() {
        this.providedObjects.clear();
    }

    protected void shutdownAll() {
        EzyProcessor.processWithLogException(this.validationService::shutdown);
    }

    public static abstract class Builder<T, B extends Builder>
    implements EzyBuilder<EzyObjectProvider<T>> {
        protected long validationInterval = 100L;
        protected long validationDelay = 3000L;
        protected EzyObjectFactory<T> objectFactory;
        protected ScheduledExecutorService validationService;

        public B objectFactory(EzyObjectFactory<T> objectFactory) {
            this.objectFactory = objectFactory;
            return (B)this;
        }

        public B validationDelay(long validationDelay) {
            this.validationDelay = validationDelay;
            return (B)this;
        }

        public B validationInterval(long validationInterval) {
            this.validationInterval = validationInterval;
            return (B)this;
        }

        public B validationService(ScheduledExecutorService validationService) {
            this.validationService = validationService;
            return (B)this;
        }

        protected abstract String getValidationThreadPoolName();

        protected EzyObjectFactory<T> getObjectFactory() {
            return this.objectFactory != null ? this.objectFactory : this.newObjectFactory();
        }

        protected EzyObjectFactory<T> newObjectFactory() {
            throw new EzyNotImplementedException("you must implement newObjectFactory method when objectFactory is null");
        }

        protected ScheduledExecutorService getValidationService() {
            return this.validationService != null ? this.validationService : this.newValidationService();
        }

        protected ScheduledExecutorService newValidationService() {
            ScheduledExecutorService service = EzyExecutors.newSingleThreadScheduledExecutor((ThreadFactory)this.newValidationThreadFactory());
            Runtime.getRuntime().addShutdownHook(new Thread(service::shutdown));
            return service;
        }

        protected ThreadFactory newValidationThreadFactory() {
            return EzyExecutors.newThreadFactory((String)this.getValidationThreadPoolName());
        }
    }
}

