/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.net;

import com.tvd12.ezyfox.util.EzyEntry;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class PathVariables {
    private PathVariables() {
    }

    public static List<Map.Entry<String, String>> getVariables(String template, String uri) {
        String[] templatePaths = template.split("/");
        String[] uriPaths = uri.split("/");
        ArrayList<Map.Entry<String, String>> answer = new ArrayList<Map.Entry<String, String>>();
        for (int i = 0; i < templatePaths.length; ++i) {
            String templatePath = templatePaths[i];
            if (PathVariables.isPathVariable(templatePath)) {
                String varName = PathVariables.getVariableName(templatePath);
                String varValue = PathVariables.decodeUriPathValue(uriPaths[i]);
                answer.add((Map.Entry<String, String>)EzyEntry.of((Object)varName, (Object)varValue));
                continue;
            }
            if (!templatePath.equals("*")) continue;
            StringBuilder varValue = new StringBuilder();
            int lastIndex = uriPaths.length - 1;
            while (i < uriPaths.length) {
                varValue.append(PathVariables.decodeUriPathValue(uriPaths[i]));
                if (i < lastIndex) {
                    varValue.append("/");
                }
                ++i;
            }
            answer.add((Map.Entry<String, String>)EzyEntry.of((Object)"*", (Object)varValue.toString()));
            break;
        }
        return answer;
    }

    private static String decodeUriPathValue(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String getVariableName(String path) {
        return path.substring(1, path.length() - 1);
    }

    public static boolean isPathVariable(String path) {
        return path.startsWith("{") && path.endsWith("}");
    }
}

