/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.EzyByteBufferMessageReader;
import com.tvd12.ezyfox.codec.EzyDecodeHandler;
import com.tvd12.ezyfox.codec.EzyDecodeHandlers;
import com.tvd12.ezyfox.codec.EzyDecodeState;
import com.tvd12.ezyfox.codec.EzyIDecodeState;
import com.tvd12.ezyfox.codec.EzyMessage;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Queue;
import lombok.Generated;

public class EzyDefaultDecodeHandlers
extends EzyDecodeHandlers {
    protected EzyDefaultDecodeHandlers(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class ReadMessageContent
    extends AbstractDecodeHandler {
        @Override
        public EzyIDecodeState nextState() {
            return EzyDecodeState.PREPARE_MESSAGE;
        }

        @Override
        public boolean handle(ByteBuffer in, Queue<EzyMessage> out) {
            if (!this.messageReader.readContent(in)) {
                return false;
            }
            out.add(this.messageReader.get());
            return true;
        }
    }

    public static class ReadMessageSize
    extends AbstractDecodeHandler {
        protected final int maxSize;

        public ReadMessageSize(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public EzyIDecodeState nextState() {
            return EzyDecodeState.READ_MESSAGE_CONTENT;
        }

        @Override
        public boolean handle(ByteBuffer in, Queue<EzyMessage> out) {
            return this.messageReader.readSize(in, this.maxSize);
        }
    }

    public static class ReadMessageHeader
    extends AbstractDecodeHandler {
        @Override
        public EzyIDecodeState nextState() {
            return EzyDecodeState.READ_MESSAGE_SIZE;
        }

        @Override
        public boolean handle(ByteBuffer in, Queue<EzyMessage> out) {
            return this.messageReader.readHeader(in);
        }
    }

    public static class PrepareMessage
    extends AbstractDecodeHandler {
        @Override
        public EzyIDecodeState nextState() {
            return EzyDecodeState.READ_MESSAGE_HEADER;
        }

        @Override
        public boolean handle(ByteBuffer in, Queue<EzyMessage> out) {
            this.messageReader.clear();
            return true;
        }
    }

    public static abstract class AbstractDecodeHandler
    implements EzyDecodeHandler {
        protected EzyDecodeHandler nextHandler;
        protected EzyByteBufferMessageReader messageReader;

        @Override
        public EzyDecodeHandler nextHandler() {
            return this.nextHandler;
        }

        @Generated
        public void setNextHandler(EzyDecodeHandler nextHandler) {
            this.nextHandler = nextHandler;
        }

        @Generated
        public void setMessageReader(EzyByteBufferMessageReader messageReader) {
            this.messageReader = messageReader;
        }
    }

    public static class Builder
    extends EzyDecodeHandlers.Builder {
        protected int maxSize;
        protected EzyByteBufferMessageReader messageReader = new EzyByteBufferMessageReader();

        public Builder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public EzyDefaultDecodeHandlers build() {
            return new EzyDefaultDecodeHandlers(this);
        }

        @Override
        protected void addHandlers(Map<EzyIDecodeState, EzyDecodeHandler> answer) {
            ReadMessageHeader readMessageHeader = new ReadMessageHeader();
            PrepareMessage prepareMessage = new PrepareMessage();
            ReadMessageSize readMessageSize = new ReadMessageSize(this.maxSize);
            ReadMessageContent readMessageContent = new ReadMessageContent();
            answer.put(EzyDecodeState.PREPARE_MESSAGE, this.newHandler((EzyDecodeHandler)prepareMessage, (EzyDecodeHandler)readMessageHeader));
            answer.put(EzyDecodeState.READ_MESSAGE_HEADER, this.newHandler((EzyDecodeHandler)readMessageHeader, (EzyDecodeHandler)readMessageSize));
            answer.put(EzyDecodeState.READ_MESSAGE_SIZE, this.newHandler((EzyDecodeHandler)readMessageSize, (EzyDecodeHandler)readMessageContent));
            answer.put(EzyDecodeState.READ_MESSAGE_CONTENT, this.newHandler(readMessageContent));
        }

        private EzyDecodeHandler newHandler(EzyDecodeHandler handler) {
            return this.newHandler(handler, null);
        }

        private EzyDecodeHandler newHandler(EzyDecodeHandler handler, EzyDecodeHandler next) {
            return this.newHandler((AbstractDecodeHandler)handler, next);
        }

        private EzyDecodeHandler newHandler(AbstractDecodeHandler handler, EzyDecodeHandler next) {
            handler.setNextHandler(next);
            handler.setMessageReader(this.messageReader);
            return handler;
        }
    }
}

