/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.concurrent;

import com.tvd12.ezyfox.concurrent.EzyEventLoopEvent;
import com.tvd12.ezyfox.concurrent.EzyFuture;
import com.tvd12.ezyfox.concurrent.EzyFutureTask;
import com.tvd12.ezyfox.concurrent.EzyThreadFactory;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfox.util.EzyRoundRobin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class EzyEventLoopGroup
extends EzyLoggable {
    private final EzyRoundRobin<EventLoop> eventLoops;
    private final Map<EzyEventLoopEvent, EventLoop> eventLoopByEvent = new ConcurrentHashMap<EzyEventLoopEvent, EventLoop>();
    public static final int DEFAULT_MAX_SLEEP_TIME = 3;

    public EzyEventLoopGroup(int numberOfThreads) {
        this(numberOfThreads, EzyThreadFactory.builder().poolName("event-loop").build());
    }

    public EzyEventLoopGroup(int numberOfThreads, ThreadFactory threadFactory) {
        this(3, numberOfThreads, threadFactory);
    }

    public EzyEventLoopGroup(int maxSleepTime, int numberOfThreads, ThreadFactory threadFactory) {
        AtomicInteger index = new AtomicInteger();
        this.eventLoops = new EzyRoundRobin(() -> new EventLoop(index.getAndIncrement(), maxSleepTime, threadFactory), numberOfThreads);
        for (int i = 0; i < numberOfThreads; ++i) {
            ((EventLoop)((Object)this.eventLoops.get())).start();
        }
    }

    public void addEvent(EzyEventLoopEvent event) {
        EventLoop eventLoop = (EventLoop)((Object)this.eventLoops.get());
        this.eventLoopByEvent.put(event instanceof ScheduledEvent ? ((ScheduledEvent)event).event : event, eventLoop);
        eventLoop.addEvent(event);
    }

    public void addScheduleEvent(EzyEventLoopEvent event, long period) {
        this.addScheduleEvent(event, 0L, period);
    }

    public void addScheduleEvent(EzyEventLoopEvent event, long delayTime, long period) {
        this.addEvent(new ScheduledEvent(event, delayTime, period));
    }

    public void addOneTimeEvent(final Runnable task, long delayTime) {
        EzyEventLoopEvent wrapper = new EzyEventLoopEvent(){

            @Override
            public boolean call() {
                try {
                    task.run();
                }
                catch (Throwable e) {
                    EzyEventLoopGroup.this.logger.warn("call one time event error", e);
                }
                return false;
            }

            @Override
            public void onFinished() {
                EzyEventLoopGroup.this.eventLoopByEvent.remove(this);
            }
        };
        this.addEvent(new ScheduledEvent(wrapper, delayTime, delayTime));
    }

    public void removeEvent(EzyEventLoopEvent event) {
        EventLoop eventLoop = this.eventLoopByEvent.remove(event);
        if (eventLoop != null) {
            eventLoop.removeEvent(event);
        }
    }

    public void shutdown() {
        this.eventLoops.forEach(EventLoop::shutdownAndGet);
    }

    public List<EzyEventLoopEvent> shutdownAndGet() {
        ArrayList<EzyEventLoopEvent> unfinishedEvents = new ArrayList<EzyEventLoopEvent>();
        this.eventLoops.forEach(it -> unfinishedEvents.addAll(it.shutdownAndGet()));
        return unfinishedEvents;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("EzyEventLoopGroup{\n  numberOfEvents=").append(this.eventLoopByEvent.size()).append(",\n  eventLoops=[");
        this.eventLoops.forEach(it -> builder.append("\n    ").append(it));
        return builder.append("\n]}").toString();
    }

    private static final class ScheduledEvent
    implements EzyEventLoopEvent {
        private final long period;
        private final EzyEventLoopEvent event;
        private final AtomicLong nextFireTime = new AtomicLong();

        private ScheduledEvent(EzyEventLoopEvent event, long delayTime, long period) {
            this.period = period;
            this.event = event;
            this.nextFireTime.set(System.currentTimeMillis() + (delayTime <= 0L ? 0L : delayTime));
        }

        public boolean isNotFireTime() {
            return System.currentTimeMillis() < this.nextFireTime.get();
        }

        @Override
        public boolean call() {
            this.nextFireTime.addAndGet(this.period);
            return this.event.call();
        }

        @Override
        public void onFinished() {
            this.event.onFinished();
        }

        @Override
        public void onRemoved() {
            this.event.onRemoved();
        }
    }

    private static final class EventLoop
    extends EzyLoggable {
        private final int index;
        private final int maxSleepTime;
        private final AtomicBoolean active;
        private final AtomicBoolean stopped;
        private final EzyFuture shutdownFuture;
        private final ThreadFactory threadFactory;
        private final List<EzyEventLoopEvent> removeEvents;
        private final Map<EzyEventLoopEvent, EzyEventLoopEvent> events;

        private EventLoop(int index, int maxSleepTime, ThreadFactory threadFactory) {
            this.index = index;
            this.maxSleepTime = maxSleepTime;
            this.threadFactory = threadFactory;
            this.active = new AtomicBoolean();
            this.stopped = new AtomicBoolean();
            this.events = new ConcurrentHashMap<EzyEventLoopEvent, EzyEventLoopEvent>();
            this.removeEvents = new ArrayList<EzyEventLoopEvent>();
            this.shutdownFuture = new EzyFutureTask();
        }

        public void addEvent(EzyEventLoopEvent event) {
            if (!this.active.get()) {
                throw new IllegalStateException("event loop has stopped");
            }
            this.events.put(event instanceof ScheduledEvent ? ((ScheduledEvent)event).event : event, event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEvent(EzyEventLoopEvent event) {
            List<EzyEventLoopEvent> list = this.removeEvents;
            synchronized (list) {
                this.removeEvents.add(event);
            }
        }

        private void doRemoveEvent(EzyEventLoopEvent event) {
            this.events.remove(event instanceof ScheduledEvent ? ((ScheduledEvent)event).event : event);
            EzyProcessor.processWithLogException(event::onRemoved, (boolean)true);
        }

        public void start() {
            this.threadFactory.newThread(this::doStart).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doStart() {
            this.active.set(true);
            ArrayList<EzyEventLoopEvent> eventBuffers = new ArrayList<EzyEventLoopEvent>();
            while (this.active.get()) {
                long startTime = System.currentTimeMillis();
                eventBuffers.addAll(this.events.values());
                for (EzyEventLoopEvent event : eventBuffers) {
                    try {
                        Object scheduledEvent;
                        if (event instanceof ScheduledEvent && ((ScheduledEvent)(scheduledEvent = (ScheduledEvent)event)).isNotFireTime() || event.call()) continue;
                        scheduledEvent = this.removeEvents;
                        synchronized (scheduledEvent) {
                            this.removeEvents.add(event);
                        }
                        event.onFinished();
                    }
                    catch (Throwable e) {
                        this.logger.error("fatal error on event loop with event: {}", (Object)event, (Object)e);
                    }
                }
                eventBuffers.clear();
                List<EzyEventLoopEvent> list = this.removeEvents;
                synchronized (list) {
                    for (EzyEventLoopEvent event : this.removeEvents) {
                        this.doRemoveEvent(event);
                    }
                    this.removeEvents.clear();
                }
                long elapsedTime = System.currentTimeMillis() - startTime;
                long sleepTime = (long)this.maxSleepTime - elapsedTime;
                if (sleepTime <= 0L) continue;
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            EventLoop eventLoop = this;
            synchronized (eventLoop) {
                this.stopped.set(true);
                this.shutdownFuture.setResult(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<EzyEventLoopEvent> shutdownAndGet() {
            this.active.set(false);
            EventLoop eventLoop = this;
            synchronized (eventLoop) {
                if (this.stopped.get()) {
                    this.shutdownFuture.setResult(true);
                }
            }
            EzyProcessor.processSilently(this.shutdownFuture::get);
            return new ArrayList<EzyEventLoopEvent>(this.events.values());
        }

        public String toString() {
            return "EventLoop-" + this.index + "{numberOfEvents=" + this.events.size() + ", numberOfRemoveEvents=" + this.removeEvents.size() + '}';
        }
    }
}

