/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.concurrent;

import com.tvd12.ezyfox.concurrent.EzyFuture;
import com.tvd12.ezyfox.concurrent.EzyFutureMap;
import com.tvd12.ezyfox.concurrent.EzyFutureTask;
import com.tvd12.ezyfox.concurrent.exception.EzyFutureExistedException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class EzyFutureAbstractMap<K>
implements EzyFutureMap<K> {
    protected final Map<K, EzyFuture> map = this.newFutureMap();

    protected abstract Map<K, EzyFuture> newFutureMap();

    @Override
    public EzyFuture addFuture(K key) {
        return this.addFuture(key, new EzyFutureTask());
    }

    @Override
    public EzyFuture addFuture(K key, EzyFuture future) {
        EzyFuture old = this.map.putIfAbsent(key, future);
        return old == null ? future : old;
    }

    @Override
    public EzyFuture putFuture(K key) {
        AtomicBoolean existed = new AtomicBoolean(true);
        EzyFuture future = this.map.computeIfAbsent(key, k -> {
            existed.set(false);
            return new EzyFutureTask();
        });
        if (existed.get()) {
            throw new EzyFutureExistedException(key, future);
        }
        return future;
    }

    @Override
    public EzyFuture getFuture(K key) {
        return this.map.get(key);
    }

    @Override
    public EzyFuture removeFuture(K key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Map<K, EzyFuture> clear() {
        HashMap<K, EzyFuture> answer = new HashMap<K, EzyFuture>(this.map);
        this.map.clear();
        return answer;
    }
}

