/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.security.EzyMD5;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.User;
import org.youngmonkeys.ezyplatform.entity.UserRole;
import org.youngmonkeys.ezyplatform.manager.PasswordManager;
import org.youngmonkeys.ezyplatform.time.ClockProxy;
import org.youngmonkeys.ezyplatform.util.Randoms;
import org.youngmonkeys.ezyplatform.util.Sha256Uuids;
import org.youngmonkeys.ezyplatform.util.StringConverters;
import org.youngmonkeys.ezyplatform.web.model.AddUserModel;
import org.youngmonkeys.ezyplatform.web.model.UpdateUserModel;

@EzySingleton
public class WebModelToEntityConverter
extends DefaultModelToEntityConverter {
    private final PasswordManager passwordManager;

    public WebModelToEntityConverter(ClockProxy clock, ObjectMapper objectMapper, PasswordManager passwordManager) {
        super(clock, objectMapper);
        this.passwordManager = passwordManager;
    }

    public User toEntity(AddUserModel model) {
        User entity = new User();
        String username = model.getUsername();
        String email = model.getEmail();
        if (EzyStrings.isBlank((String)username)) {
            String unique = email + model.getPhone();
            username = EzyMD5.cryptUtfToLowercase((String)Sha256Uuids.generateUuid((String)unique));
        }
        entity.setUsername(username.trim());
        entity.setUuid(Sha256Uuids.generateUuid((String)username));
        entity.setEmail(StringConverters.trimOrNull((String)email));
        entity.setPhone(StringConverters.trimOrNull((String)model.getPhone()));
        String password = model.getPassword();
        if (EzyStrings.isBlank((String)password)) {
            password = Sha256Uuids.generateUuid((String)username);
        }
        entity.setPassword(this.passwordManager.hashPassword(password));
        entity.setAvatarImageId(model.getAvatarImageId());
        String displayName = model.getDisplayName();
        if (EzyStrings.isBlank((String)displayName)) {
            displayName = Randoms.randomName();
        }
        entity.setDisplayName(displayName);
        entity.setStatus(model.getStatus());
        LocalDateTime now = this.clock.nowDateTime();
        entity.setCreatedAt(now);
        entity.setUpdatedAt(now);
        return entity;
    }

    public List<UserRole> toUserRoleEntities(long userId, Collection<Long> roleIds) {
        LocalDateTime now = this.clock.nowDateTime();
        return EzyLists.newArrayList(roleIds, roleId -> new UserRole(roleId.longValue(), userId, now));
    }

    public void mergeToEntity(UpdateUserModel model, User entity) {
        entity.setEmail(StringConverters.trimOrNull((String)model.getEmail()));
        entity.setPhone(StringConverters.trimOrNull((String)model.getPhone()));
        entity.setUrl(StringConverters.trimOrNull((String)model.getWebsite()));
        entity.setDisplayName(StringConverters.trimOrNull((String)model.getDisplayName()));
        entity.setUpdatedAt(this.clock.nowDateTime());
    }
}

