/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyfox.io.EzyCollections;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.core.exception.HttpBadRequestException;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import com.tvd12.ezyhttp.core.resources.ResourceUploadManager;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Async;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestCookie;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.bash.AdminBash;
import org.youngmonkeys.ezyplatform.admin.bash.AdminCommand;
import org.youngmonkeys.ezyplatform.admin.controller.service.AdminDownloadControllerService;
import org.youngmonkeys.ezyplatform.admin.converter.AdminDataToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.data.ProjectInstallation;
import org.youngmonkeys.ezyplatform.admin.entity.AdminProjectStatus;
import org.youngmonkeys.ezyplatform.admin.exception.ProjectInstallationException;
import org.youngmonkeys.ezyplatform.admin.jdbc.AdminSqlScriptsRunner;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminProjectInstallationQueue;
import org.youngmonkeys.ezyplatform.admin.manager.AdminTargetManager;
import org.youngmonkeys.ezyplatform.admin.request.DoProjectActionRequest;
import org.youngmonkeys.ezyplatform.admin.response.AdminProjectVersionStatusResponse;
import org.youngmonkeys.ezyplatform.admin.response.ProjectResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminProjectService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.admin.statistics.AdminEzyPlatformStatisticsSender;
import org.youngmonkeys.ezyplatform.admin.validator.AdminProjectsValidator;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.constant.ModuleAction;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.io.FolderProxy;

@Api
@Authenticated
@EzyFeature(value="plugin_management")
@Controller(value="/api/v1")
public class AdminApiProjectsController
extends EzyLoggable {
    private final AdminBash bash;
    private final AdminFileSystemManager fileSystemManager;
    private final AdminModuleManager moduleManager;
    private final AdminEzyPlatformStatisticsSender platformStatisticsSender;
    private final AdminProjectInstallationQueue projectInstallationQueue;
    private final ResourceUploadManager resourceUploadManager;
    private final AdminSqlScriptsRunner sqlScriptsRunner;
    private final AdminTargetManager targetManager;
    private final AdminProjectService projectService;
    private final AdminSettingService settingService;
    private final AdminDownloadControllerService downloadControllerService;
    private final AdminProjectsValidator projectsValidator;
    private final AdminDataToResponseConverter dataToResponseConverter;

    @DoGet(value="/projects/{projectName}")
    public ProjectResponse projectsProjectNameGet(@PathVariable String projectName) {
        Module module = this.moduleManager.getFirstModuleOfProject(projectName);
        if (module == null) {
            throw new HttpNotFoundException(Collections.singletonMap("project", "notFound"));
        }
        return this.dataToResponseConverter.toResponse(module);
    }

    @DoGet(value="/projects/{projectName}/module-types")
    public List<String> projectsModuleNameModuleTypesGet(@PathVariable String projectName, @RequestParam(value="active") Boolean active) {
        List<ModuleType> moduleTypes = this.moduleManager.getAllModuleTypesOfProject(projectName);
        if (EzyCollections.isEmpty(moduleTypes)) {
            throw new HttpNotFoundException(Collections.singletonMap("project", "notFound"));
        }
        List<ModuleType> filteredModuleTypes = moduleTypes;
        if (active != null) {
            filteredModuleTypes = new ArrayList<ModuleType>();
            for (ModuleType moduleType : moduleTypes) {
                Module module = this.moduleManager.getModule(moduleType, projectName);
                if (module == null || module.isActive() != active.booleanValue()) continue;
                filteredModuleTypes.add(moduleType);
            }
        }
        return EzyLists.newArrayList(filteredModuleTypes, ModuleType::getName);
    }

    @DoGet(value="/projects/check-dependencies")
    public ResponseEntity projectsCheckDependenciesGet() {
        Set<String> projectNamesHasNewVersion = this.moduleManager.getActivatedProjectNamesHasNewVersion();
        for (String projectName : projectNamesHasNewVersion) {
            this.projectsValidator.validateProjectAction(ModuleAction.ACTIVATE, projectName, this.moduleManager.getModuleTypesOfProject(projectName));
        }
        return ResponseEntity.noContent();
    }

    @DoGet(value="/projects/version-status")
    public Set<AdminProjectVersionStatusResponse> projectsVersionStatusGet() {
        HashSet<AdminProjectVersionStatusResponse> answer = new HashSet<AdminProjectVersionStatusResponse>();
        this.projectInstallationQueue.getProjectsInQueue().forEach(it -> answer.add(AdminProjectVersionStatusResponse.builder().projectName(it.getProjectName()).version(it.getVersion()).status(AdminProjectStatus.INSTALLING).build()));
        this.moduleManager.getAllProjects().forEach(it -> answer.add(AdminProjectVersionStatusResponse.builder().projectName(it.getProjectName()).version(it.getVersion()).status(AdminProjectStatus.INSTALLED).build()));
        return answer;
    }

    @DoPost(value="/projects/upload")
    public ResponseEntity projectsUploadPost(HttpServletRequest request, @AdminId long adminId) throws Exception {
        Part filePart = request.getPart("file");
        this.projectsValidator.validateUploadFile(filePart);
        String submittedFileName = filePart.getSubmittedFileName();
        File outputFile = this.fileSystemManager.getUploadProjectFile(submittedFileName);
        FolderProxy.createNewFile((File)outputFile);
        try (OutputStream outputStream = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
            this.resourceUploadManager.drain(filePart.getInputStream(), outputStream, this.settingService.getMaxProjectBundleFileSize());
        }
        ProjectInstallation installation = ProjectInstallation.ofUploadFileName(adminId, submittedFileName);
        this.projectInstallationQueue.add(installation);
        try {
            installation.await();
        }
        catch (ProjectInstallationException e) {
            this.logger.info("install: {} failed due to: {}", (Object)submittedFileName, (Object)e.getMessage());
            throw new HttpBadRequestException(Collections.singletonMap("fileContent", e.getMessage()));
        }
        return ResponseEntity.ok(Collections.singletonMap("projectName", installation.getProjectName()));
    }

    @DoPost(value="/projects/{projectName}/{version}/install")
    public ResponseEntity projectsProjectNameVersionInstallPost(@AdminId long adminId, @RequestCookie(value="marketAccessToken") String marketAccessToken, @PathVariable String projectName, @PathVariable String version) throws Exception {
        this.projectsValidator.validateInstallation(projectName, version);
        ProjectInstallation installation = ProjectInstallation.builder().adminId(adminId).projectName(projectName).version(version).marketAccessToken(marketAccessToken).build();
        this.projectInstallationQueue.add(installation);
        try {
            installation.await();
        }
        catch (ProjectInstallationException e) {
            this.logger.info("install: {}-{} failed due to: ", new Object[]{projectName, version, e});
        }
        return ResponseEntity.noContent();
    }

    @DoPost(value="/projects/{projectName}/activate")
    public ResponseEntity projectsProjectNameActivatePost(@PathVariable String projectName, @RequestBody DoProjectActionRequest request) {
        try {
            this.sqlScriptsRunner.runProjectScripts(projectName);
        }
        catch (Exception e) {
            return ResponseEntity.builder().status(403).body(Collections.singletonMap("sqlPermission", "denied")).build();
        }
        this.doProjectAction(ModuleAction.ACTIVATE, projectName, request);
        return ResponseEntity.noContent();
    }

    @DoPost(value="/projects/{projectName}/deactivate")
    public ResponseEntity projectsProjectNameDeactivatePost(@PathVariable String projectName, @RequestBody DoProjectActionRequest request) {
        this.doProjectAction(ModuleAction.DEACTIVATE, projectName, request);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/projects/{projectName}")
    public ResponseEntity projectsProjectNameDelete(@PathVariable String projectName, @RequestBody DoProjectActionRequest request) {
        this.doProjectAction(ModuleAction.DELETE, projectName, request);
        return ResponseEntity.noContent();
    }

    @Async
    @DoGet(value="/projects/{projectName}/sql")
    public void projectsProjectNameSqlGet(RequestArguments arguments, @PathVariable String projectName) throws Exception {
        List sqlScripFiles = EzyMaps.flattenValues(this.moduleManager.listSqlScripFilesOfProject(projectName));
        this.downloadControllerService.downloadSqlFiles(arguments, sqlScripFiles);
    }

    private void doProjectAction(ModuleAction action, String projectName, DoProjectActionRequest request) {
        List<ModuleType> moduleTypes = request.getModuleTypeEnums();
        Collection<ModuleType> restartModuleTypes = moduleTypes;
        boolean restart = request.isRestart();
        if (restart) {
            restartModuleTypes = new HashSet<ModuleType>(moduleTypes);
            restartModuleTypes.addAll(this.moduleManager.getModuleTypesOfProjectDependencies(projectName));
        }
        this.projectsValidator.validateProjectAction(action, projectName, moduleTypes);
        String projectVersion = this.moduleManager.getProjectVersion(projectName);
        for (ModuleType moduleType : moduleTypes) {
            this.doModuleAction(moduleType, projectName, action);
        }
        if (action == ModuleAction.DELETE && !this.moduleManager.containsProject(projectName)) {
            this.projectService.removeProject(projectName);
        }
        this.platformStatisticsSender.sendProjectActionStatistics(projectName, projectVersion, action, moduleTypes);
        if (action != ModuleAction.ACTIVATE) {
            this.moduleManager.activateDefaultThemeIfNeed();
        }
        if (restart) {
            List<String> targetNames = this.moduleManager.getTargetNames(restartModuleTypes).stream().filter(this.targetManager::isEnableTargetByName).collect(Collectors.toList());
            this.logger.info("restart module types: {}", restartModuleTypes);
            this.logger.info("target names: {}", targetNames);
            targetNames.forEach(it -> this.bash.run(AdminCommand.RESTART, (String)it));
        }
    }

    private void doModuleAction(ModuleType moduleType, String projectName, ModuleAction action) {
        if (action == ModuleAction.ACTIVATE && moduleType == ModuleType.THEME) {
            for (Module theme : this.moduleManager.getActivatedThemes()) {
                String themeName = theme.getName();
                List<ModuleType> moduleTypes = this.moduleManager.getModuleTypesOfProject(themeName);
                for (ModuleType themeModuleType : moduleTypes) {
                    this.moduleManager.actModule(themeModuleType, themeName, ModuleAction.DEACTIVATE);
                    this.logger.info("deactivated theme: {}, module: {}", (Object)themeName, (Object)themeModuleType);
                }
            }
        }
        this.logger.info("{} module: {} type: {}", new Object[]{action, projectName, moduleType});
        this.moduleManager.actModule(moduleType, projectName, action);
    }

    @Generated
    public AdminApiProjectsController(AdminBash bash, AdminFileSystemManager fileSystemManager, AdminModuleManager moduleManager, AdminEzyPlatformStatisticsSender platformStatisticsSender, AdminProjectInstallationQueue projectInstallationQueue, ResourceUploadManager resourceUploadManager, AdminSqlScriptsRunner sqlScriptsRunner, AdminTargetManager targetManager, AdminProjectService projectService, AdminSettingService settingService, AdminDownloadControllerService downloadControllerService, AdminProjectsValidator projectsValidator, AdminDataToResponseConverter dataToResponseConverter) {
        this.bash = bash;
        this.fileSystemManager = fileSystemManager;
        this.moduleManager = moduleManager;
        this.platformStatisticsSender = platformStatisticsSender;
        this.projectInstallationQueue = projectInstallationQueue;
        this.resourceUploadManager = resourceUploadManager;
        this.sqlScriptsRunner = sqlScriptsRunner;
        this.targetManager = targetManager;
        this.projectService = projectService;
        this.settingService = settingService;
        this.downloadControllerService = downloadControllerService;
        this.projectsValidator = projectsValidator;
        this.dataToResponseConverter = dataToResponseConverter;
    }
}

