/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.decorator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyLists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.admin.converter.AdminModelToResponseConverter;
import org.youngmonkeys.ezyplatform.admin.response.UserResponse;
import org.youngmonkeys.ezyplatform.admin.response.UserRoleMemberResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminMediaService;
import org.youngmonkeys.ezyplatform.admin.service.AdminUserRoleService;
import org.youngmonkeys.ezyplatform.model.MediaNameModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.model.UserRoleModel;

@EzySingleton
public class AdminUserDecorator {
    private final AdminMediaService mediaService;
    private final AdminUserRoleService userRoleService;
    private final AdminModelToResponseConverter modelToResponseConverter;

    public List<UserResponse> decorateToUserResponses(List<UserModel> models) {
        Set mediaIds = models.stream().map(UserModel::getAvatarImageId).filter(it -> it > 0L).collect(Collectors.toSet());
        Map mediaById = this.mediaService.getMediaNameMapByIds(mediaIds);
        return EzyLists.newArrayList(models, it -> this.modelToResponseConverter.toResponse((UserModel)it, (MediaNameModel)mediaById.get(it.getAvatarImageId())));
    }

    public PaginationModel<UserResponse> decorateToUserResponsePagination(PaginationModel<UserModel> pagination) {
        List models = pagination.getItems();
        Set mediaIds = models.stream().map(UserModel::getAvatarImageId).filter(it -> it > 0L).collect(Collectors.toSet());
        Map mediaById = this.mediaService.getMediaNameMapByIds(mediaIds);
        return pagination.map(it -> this.modelToResponseConverter.toResponse((UserModel)it, (MediaNameModel)mediaById.get(it.getAvatarImageId())));
    }

    public PaginationModel<UserRoleMemberResponse> decorateToUserRoleMemberResponsePagination(PaginationModel<UserModel> pagination, long roleId) {
        List userIds = EzyLists.newArrayList((Collection)pagination.getItems(), UserModel::getId);
        Map<Long, UserRoleModel> userRoleMap = this.userRoleService.getUserRoleMapByRoleIdAndUserIds(roleId, userIds);
        return pagination.map(it -> this.modelToResponseConverter.toUserRoleMemberResponse((UserModel)it, (UserRoleModel)userRoleMap.get(it.getId())));
    }

    @Generated
    public AdminUserDecorator(AdminMediaService mediaService, AdminUserRoleService userRoleService, AdminModelToResponseConverter modelToResponseConverter) {
        this.mediaService = mediaService;
        this.userRoleService = userRoleService;
        this.modelToResponseConverter = modelToResponseConverter;
    }
}

