/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.data;

import com.tvd12.ezyfox.io.EzyStrings;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

public class ModuleDependency {
    private String projectName;
    private String projectVersion = "latest";

    public ModuleDependency(String projectName) {
        this.projectName = projectName;
    }

    public static ModuleDependency parseOne(String str) {
        String[] strs = str.split(":");
        if (strs.length == 1) {
            return new ModuleDependency(strs[0].trim());
        }
        return new ModuleDependency(strs[0].trim(), strs[1].trim());
    }

    public static Set<ModuleDependency> parseMulti(String str) {
        String[] strs = str.split(",");
        HashSet<ModuleDependency> dependencies = new HashSet<ModuleDependency>();
        for (String one : strs) {
            if (!EzyStrings.isNotEmpty((CharSequence)one)) continue;
            dependencies.add(ModuleDependency.parseOne(one));
        }
        return dependencies;
    }

    public String toString() {
        return this.projectName + ':' + this.projectVersion;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getProjectVersion() {
        return this.projectVersion;
    }

    @Generated
    public ModuleDependency(String projectName, String projectVersion) {
        this.projectName = projectName;
        this.projectVersion = projectVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleDependency)) {
            return false;
        }
        ModuleDependency other = (ModuleDependency)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        return !(this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModuleDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        return result;
    }
}

