/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.builder;

import com.tvd12.ezyfox.concurrent.EzyExecutors;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfox.util.EzyStartable;
import com.tvd12.ezyfoxserver.EzyServer;
import com.tvd12.ezyfoxserver.EzySimpleApplication;
import com.tvd12.ezyfoxserver.EzySimplePlugin;
import com.tvd12.ezyfoxserver.EzySimpleZone;
import com.tvd12.ezyfoxserver.EzyZone;
import com.tvd12.ezyfoxserver.builder.EzyServerContextBuilder;
import com.tvd12.ezyfoxserver.context.EzyAppContext;
import com.tvd12.ezyfoxserver.context.EzyPluginContext;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.context.EzyServerContexts;
import com.tvd12.ezyfoxserver.context.EzySimpleAppContext;
import com.tvd12.ezyfoxserver.context.EzySimplePluginContext;
import com.tvd12.ezyfoxserver.context.EzySimpleServerContext;
import com.tvd12.ezyfoxserver.context.EzySimpleZoneContext;
import com.tvd12.ezyfoxserver.context.EzyZoneContext;
import com.tvd12.ezyfoxserver.delegate.EzyAppUserDelegate;
import com.tvd12.ezyfoxserver.delegate.EzySimpleAppUserDelegate;
import com.tvd12.ezyfoxserver.delegate.EzySimpleUserDelegate;
import com.tvd12.ezyfoxserver.delegate.EzyUserDelegate;
import com.tvd12.ezyfoxserver.setting.EzyAppSetting;
import com.tvd12.ezyfoxserver.setting.EzyEventControllersSetting;
import com.tvd12.ezyfoxserver.setting.EzyPluginSetting;
import com.tvd12.ezyfoxserver.setting.EzySettings;
import com.tvd12.ezyfoxserver.setting.EzyUserManagementSetting;
import com.tvd12.ezyfoxserver.setting.EzyZoneSetting;
import com.tvd12.ezyfoxserver.socket.EzyBlockingSocketUserRemovalQueue;
import com.tvd12.ezyfoxserver.socket.EzySocketUserRemovalQueue;
import com.tvd12.ezyfoxserver.wrapper.EzyAppUserManager;
import com.tvd12.ezyfoxserver.wrapper.EzyEventControllers;
import com.tvd12.ezyfoxserver.wrapper.EzyZoneUserManager;
import com.tvd12.ezyfoxserver.wrapper.impl.EzyAppUserManagerImpl;
import com.tvd12.ezyfoxserver.wrapper.impl.EzyEventControllersImpl;
import com.tvd12.ezyfoxserver.wrapper.impl.EzyZoneUserManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;

public class EzySimpleServerContextBuilder<B extends EzySimpleServerContextBuilder<B>>
implements EzyServerContextBuilder<B> {
    protected EzyServer server;
    protected EzySocketUserRemovalQueue socketUserRemovalQueue = new EzyBlockingSocketUserRemovalQueue();

    @Override
    public B server(EzyServer server) {
        this.server = server;
        return (B)this;
    }

    public EzyServerContext build() {
        EzySimpleServerContext context = this.newServerContext();
        context.setServer(this.server);
        context.addZoneContexts(this.newZoneContexts(context));
        context.setProperty(EzySocketUserRemovalQueue.class, this.socketUserRemovalQueue);
        context.init();
        return context;
    }

    protected EzySimpleServerContext newServerContext() {
        return new EzySimpleServerContext();
    }

    protected Collection<EzyZoneContext> newZoneContexts(EzyServerContext parent) {
        ArrayList<EzyZoneContext> contexts = new ArrayList<EzyZoneContext>();
        EzySettings settings = EzyServerContexts.getSettings(parent);
        for (Integer zoneId : settings.getZoneIds()) {
            EzyZoneSetting zoneSetting = settings.getZoneById(zoneId);
            EzySimpleZone zone = new EzySimpleZone();
            zone.setSetting(zoneSetting);
            EzyUserDelegate userDelegate = this.newUserDelegate(parent);
            EzyZoneUserManager userManager = this.newZoneUserManager(zoneSetting, userDelegate);
            EzyEventControllers eventControllers = this.newEventControllers(zoneSetting.getEventControllers());
            zone.setUserManager(userManager);
            zone.setEventControllers(eventControllers);
            EzySimpleZoneContext zoneContext = new EzySimpleZoneContext();
            zoneContext.setParent(parent);
            zoneContext.setZone(zone);
            zoneContext.addAppContexts(this.newAppContexts(zoneContext));
            zoneContext.addPluginContexts(this.newPluginContexts(zoneContext));
            zoneContext.init();
            contexts.add(zoneContext);
            EzyProcessor.processWithException(() -> ((EzyStartable)((EzyStartable)userManager)).start());
        }
        return contexts;
    }

    protected EzyUserDelegate newUserDelegate(EzyServerContext context) {
        return new EzySimpleUserDelegate(context, this.socketUserRemovalQueue);
    }

    protected EzyZoneUserManager newZoneUserManager(EzyZoneSetting zoneSetting, EzyUserDelegate userDelegate) {
        EzyUserManagementSetting setting = zoneSetting.getUserManagement();
        return ((EzyZoneUserManagerImpl.Builder)EzyZoneUserManagerImpl.builder().userDelegate(userDelegate).zoneName(zoneSetting.getName()).maxUsers(zoneSetting.getMaxUsers())).maxIdleTime(setting.getUserMaxIdleTime()).build();
    }

    protected EzyEventControllers newEventControllers() {
        return new EzyEventControllersImpl();
    }

    protected EzyEventControllers newEventControllers(EzyEventControllersSetting setting) {
        return EzyEventControllersImpl.create(setting);
    }

    protected Collection<EzyAppContext> newAppContexts(EzyZoneContext parent) {
        EzyZone zone = parent.getZone();
        EzyZoneSetting zoneSetting = zone.getSetting();
        ArrayList<EzyAppContext> contexts = new ArrayList<EzyAppContext>();
        for (Integer appId : zoneSetting.getAppIds()) {
            contexts.add(this.newAppContext(parent, zoneSetting.getAppById(appId)));
        }
        return contexts;
    }

    protected EzyAppContext newAppContext(EzyZoneContext parent, EzyAppSetting setting) {
        EzySimpleAppUserDelegate userDelegate = new EzySimpleAppUserDelegate();
        EzyAppUserManager appUserManager = this.newAppUserManager(setting, userDelegate);
        EzyEventControllers eventControllers = this.newEventControllers();
        EzySimpleApplication app = new EzySimpleApplication();
        app.setSetting(setting);
        app.setUserManager(appUserManager);
        app.setEventControllers(eventControllers);
        ScheduledExecutorService appExecutorService = this.newAppExecutorService(setting);
        EzySimpleAppContext appContext = new EzySimpleAppContext();
        userDelegate.setAppContext(appContext);
        appContext.setApp(app);
        appContext.setParent(parent);
        appContext.setExecutorService(appExecutorService);
        appContext.init();
        return appContext;
    }

    protected EzyAppUserManager newAppUserManager(EzyAppSetting setting, EzyAppUserDelegate userDelegate) {
        return ((EzyAppUserManagerImpl.Builder)EzyAppUserManagerImpl.builder().appName(setting.getName()).maxUsers(setting.getMaxUsers())).userDelegate(userDelegate).build();
    }

    protected Collection<EzyPluginContext> newPluginContexts(EzySimpleZoneContext parent) {
        EzyZone zone = parent.getZone();
        EzyZoneSetting zoneSetting = zone.getSetting();
        ArrayList<EzyPluginContext> contexts = new ArrayList<EzyPluginContext>();
        for (Integer appId : zoneSetting.getPluginIds()) {
            contexts.add(this.newPluginContext(parent, zoneSetting.getPluginById(appId)));
        }
        return contexts;
    }

    protected EzyPluginContext newPluginContext(EzySimpleZoneContext parent, EzyPluginSetting setting) {
        EzySimplePlugin plugin = new EzySimplePlugin();
        plugin.setSetting(setting);
        plugin.setEventControllers(this.newEventControllers());
        EzySimplePluginContext pluginContext = new EzySimplePluginContext();
        pluginContext.setPlugin(plugin);
        pluginContext.setParent(parent);
        pluginContext.setExecutorService(this.newPluginExecutorService(setting));
        pluginContext.init();
        return pluginContext;
    }

    protected ScheduledExecutorService newAppExecutorService(EzyAppSetting app) {
        String threadName = "app-" + app.getName() + "-thread";
        int threadPoolSize = app.getThreadPoolSize();
        if (threadPoolSize > 0) {
            return EzyExecutors.newScheduledThreadPool((int)threadPoolSize, (String)threadName);
        }
        return EzyExecutors.newErrorScheduledExecutor((String)("must set app " + app.getName() + "'s 'thread-pool-size'"));
    }

    protected ScheduledExecutorService newPluginExecutorService(EzyPluginSetting plugin) {
        String threadName = "plugin-" + plugin.getName() + "-thread";
        int threadPoolSize = plugin.getThreadPoolSize();
        if (threadPoolSize > 0) {
            return EzyExecutors.newScheduledThreadPool((int)threadPoolSize, (String)threadName);
        }
        return EzyExecutors.newErrorScheduledExecutor((String)("must set plugin " + plugin.getName() + "'s 'thread-pool-size'"));
    }
}

