/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.controller;

import com.tvd12.ezyfox.entity.EzyData;
import com.tvd12.ezyfox.util.EzyEntityBuilders;
import com.tvd12.ezyfoxserver.EzyZone;
import com.tvd12.ezyfoxserver.constant.EzyDisconnectReason;
import com.tvd12.ezyfoxserver.constant.EzyEventType;
import com.tvd12.ezyfoxserver.constant.EzyLoginError;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.context.EzyServerContexts;
import com.tvd12.ezyfoxserver.context.EzyZoneContext;
import com.tvd12.ezyfoxserver.context.EzyZoneContexts;
import com.tvd12.ezyfoxserver.entity.EzyAbstractSession;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.entity.EzySimpleUser;
import com.tvd12.ezyfoxserver.entity.EzyUser;
import com.tvd12.ezyfoxserver.event.EzyEvent;
import com.tvd12.ezyfoxserver.event.EzySimpleUserAddedEvent;
import com.tvd12.ezyfoxserver.event.EzyUserLoginEvent;
import com.tvd12.ezyfoxserver.exception.EzyLoginErrorException;
import com.tvd12.ezyfoxserver.response.EzyLoginParams;
import com.tvd12.ezyfoxserver.response.EzyLoginResponse;
import com.tvd12.ezyfoxserver.response.EzyResponse;
import com.tvd12.ezyfoxserver.setting.EzyStreamingSetting;
import com.tvd12.ezyfoxserver.setting.EzyUserManagementSetting;
import com.tvd12.ezyfoxserver.setting.EzyZoneSetting;
import com.tvd12.ezyfoxserver.statistics.EzyUserStatistics;
import com.tvd12.ezyfoxserver.wrapper.EzySessionManager;
import com.tvd12.ezyfoxserver.wrapper.EzyZoneUserManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;

public class EzyLoginProcessor
extends EzyEntityBuilders {
    private final EzyUserStatistics userStats;
    private final EzyServerContext serverContext;
    private final EzySessionManager<EzySession> sessionManager;
    private static final AtomicLong GUEST_COUNT = new AtomicLong();

    public EzyLoginProcessor(EzyServerContext serverContext) {
        this.serverContext = serverContext;
        this.sessionManager = EzyServerContexts.getSessionManager(serverContext);
        this.userStats = EzyServerContexts.getStatistics(serverContext).getUserStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(EzyZoneContext zoneContext, EzyUserLoginEvent event) {
        EzyUser user;
        boolean alreadyLoggedIn;
        EzyZone zone = zoneContext.getZone();
        EzyZoneSetting zoneSetting = zone.getSetting();
        EzyUserManagementSetting userManagementSetting = zoneSetting.getUserManagement();
        String username = this.checkUsername(event.getUsername(), userManagementSetting.getUserNamePattern(), userManagementSetting.isAllowGuestLogin(), userManagementSetting.getGuestNamePrefix());
        String password = event.getPassword();
        EzyZoneUserManager userManager = zone.getUserManager();
        EzySession session = event.getSession();
        Lock lock = userManager.getLock(username);
        lock.lock();
        try {
            alreadyLoggedIn = userManager.containsUser(username);
            user = alreadyLoggedIn ? userManager.getUser(username) : this.newUser(zoneSetting, userManagementSetting, username, password, event.getUserProperties());
            int maxSessionPerUser = userManagementSetting.getMaxSessionPerUser();
            boolean allowChangeSession = userManagementSetting.isAllowChangeSession();
            EzyStreamingSetting streamingSetting = zoneSetting.getStreaming();
            boolean streamingEnable = streamingSetting.isEnable() && event.isStreamingEnable();
            this.processUserSessions(user, session, maxSessionPerUser, allowChangeSession, streamingEnable);
            this.addUserToManager(userManager, user, session, alreadyLoggedIn);
        }
        finally {
            lock.unlock();
            userManager.removeLock(username);
        }
        this.fireUserAddedEvent(zoneContext, user, session, (EzyData)event.getData(), alreadyLoggedIn);
        EzyResponse response = this.newLoginResponse(zoneContext, user, event.getOutput());
        this.serverContext.send(response, session, false);
    }

    protected String checkUsername(String username, String userNamePattern, boolean allowGuestLogin, String guestNamePrefix) {
        if (username != null && username.matches(userNamePattern)) {
            return username;
        }
        if (allowGuestLogin) {
            long userId = GUEST_COUNT.incrementAndGet();
            return guestNamePrefix + userId;
        }
        throw new EzyLoginErrorException(EzyLoginError.INVALID_USERNAME);
    }

    protected void processUserSessions(EzyUser user, EzySession session, int maxSessionPerUser, boolean allowChangeSession, boolean streamingEnable) {
        if (maxSessionPerUser <= 0) {
            throw new EzyLoginErrorException(EzyLoginError.MAXIMUM_SESSION);
        }
        int sessionCount = user.getSessionCount();
        if (!(sessionCount < maxSessionPerUser || sessionCount <= maxSessionPerUser && maxSessionPerUser <= 1 && allowChangeSession)) {
            throw new EzyLoginErrorException(EzyLoginError.MAXIMUM_SESSION);
        }
        session.setLoggedIn(true);
        session.setLoggedInTime(System.currentTimeMillis());
        ((EzyAbstractSession)session).setOwner(user);
        ((EzyAbstractSession)session).setStreamingEnable(streamingEnable);
        if (sessionCount == 0) {
            user.addSession(session);
        } else if (maxSessionPerUser > 1) {
            user.addSession(session);
        } else {
            this.processChangeSession(user, session);
        }
        this.sessionManager.addLoggedInSession(session);
    }

    protected void processChangeSession(EzyUser user, EzySession session) {
        List<EzySession> oldSessions = user.changeSession(session);
        for (EzySession oldSession : oldSessions) {
            this.sessionManager.removeSession(oldSession, EzyDisconnectReason.ANOTHER_SESSION_LOGIN);
        }
    }

    protected void addUserToManager(EzyZoneUserManager userManager, EzyUser user, EzySession session, boolean alreadyLoggedIn) {
        if (alreadyLoggedIn) {
            userManager.bind(session, user);
        } else {
            userManager.addUser(session, user);
            this.userStats.addUsers(1);
            this.userStats.setCurrentUsers(userManager.getUserCount());
        }
    }

    protected void fireUserAddedEvent(EzyZoneContext zoneContext, EzyUser user, EzySession session, EzyData loginData, boolean alreadyLoggedIn) {
        if (!alreadyLoggedIn) {
            this.doFireUserAddedEvent(zoneContext, new EzySimpleUserAddedEvent(user, session, loginData));
        }
    }

    protected void doFireUserAddedEvent(EzyZoneContext zoneContext, EzyEvent event) {
        try {
            zoneContext.broadcastPlugins(EzyEventType.USER_ADDED, event, true);
        }
        catch (Exception e) {
            String zoneName = zoneContext.getZone().getSetting().getName();
            this.logger.error("broadcast user added to zone: {} to plugins error", (Object)zoneName, (Object)e);
        }
    }

    protected EzyUser newUser(EzyZoneSetting zoneSetting, EzyUserManagementSetting userManagementSetting, String newUserName, String password, Map<Object, Object> properties) {
        EzySimpleUser user = new EzySimpleUser();
        user.setName(newUserName);
        user.setPassword(password);
        user.setZoneId(zoneSetting.getId());
        user.setMaxIdleTime(userManagementSetting.getUserMaxIdleTime());
        user.setMaxSessions(userManagementSetting.getMaxSessionPerUser());
        user.setProperties(properties);
        return user;
    }

    protected EzyResponse newLoginResponse(EzyZoneContext zoneContext, EzyUser user, EzyData loginOutputData) {
        EzyZoneSetting zoneSetting = EzyZoneContexts.getZoneSetting(zoneContext);
        EzyLoginParams params = new EzyLoginParams();
        params.setData(loginOutputData);
        params.setUserId(user.getId());
        params.setUsername(user.getName());
        params.setZoneId(zoneSetting.getId());
        params.setZoneName(zoneSetting.getName());
        return new EzyLoginResponse(params);
    }
}

