/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.support.manager;

import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.util.EzyDestroyable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EzyFeatureCommandManager
implements EzyDestroyable {
    private final Map<String, String> featureByCommand = new ConcurrentHashMap<String, String>();
    private final Map<String, Set<String>> commandsByFeature = new ConcurrentHashMap<String, Set<String>>();

    public void addFeatureCommand(String feature, String command) {
        this.featureByCommand.put(command, feature);
        this.commandsByFeature.computeIfAbsent(feature, k -> ConcurrentHashMap.newKeySet()).add(command);
    }

    public List<String> getFeatures() {
        return new ArrayList<String>(this.commandsByFeature.keySet());
    }

    public String getFeatureByCommand(String command) {
        return this.featureByCommand.get(command);
    }

    public List<String> getCommandsByFeature(String feature) {
        return new ArrayList<String>((Collection)this.commandsByFeature.get(feature));
    }

    public Map<String, String> getFeatureByCommandMap() {
        return new HashMap<String, String>(this.featureByCommand);
    }

    public Map<String, List<String>> getCommandsByFeatureMap() {
        return EzyMaps.newHashMapNewValues(this.commandsByFeature, ArrayList::new);
    }

    public void destroy() {
        this.featureByCommand.clear();
        this.commandsByFeature.clear();
    }
}

