/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.config;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.config.AbstractMessageProvider;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;

@EzySingleton
public class AdminMessageProvider
extends AbstractMessageProvider {
    private final AdminModuleManager moduleManager;

    public AdminMessageProvider(AdminModuleManager moduleManager, AdminFileSystemManager fileSystemManager) {
        super((FileSystemManager)fileSystemManager);
        this.moduleManager = moduleManager;
    }

    protected TargetType getInclusiveTargetType() {
        return TargetType.ADMIN;
    }

    protected ModuleType[] getInclusiveModuleTypes() {
        return new ModuleType[]{ModuleType.ADMIN_PLUGIN};
    }

    protected Map<ModuleType, List<String>> getInclusiveModulesMapByModuleTypes(ModuleType[] moduleTypes) {
        HashMap<ModuleType, List<String>> answer = new HashMap<ModuleType, List<String>>();
        for (ModuleType moduleType : moduleTypes) {
            List<Module> modules = this.moduleManager.getModules(moduleType);
            for (Module module : modules) {
                if (!module.isActive()) continue;
                answer.computeIfAbsent(moduleType, k -> new ArrayList()).add(module.getName());
            }
        }
        return answer;
    }
}

