/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.controller.service;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import org.youngmonkeys.ezyplatform.controller.service.UserControllerService;
import org.youngmonkeys.ezyplatform.entity.UserStatus;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.model.UserAccessTokenModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.pagination.DefaultUserFilter;
import org.youngmonkeys.ezyplatform.pagination.UserPaginationParameterConverter;
import org.youngmonkeys.ezyplatform.service.PaginationUserService;
import org.youngmonkeys.ezyplatform.web.converter.WebRequestToModelConverter;
import org.youngmonkeys.ezyplatform.web.model.AddUserModel;
import org.youngmonkeys.ezyplatform.web.pagination.WebUserPaginationParameterConverter;
import org.youngmonkeys.ezyplatform.web.request.LoginRequest;
import org.youngmonkeys.ezyplatform.web.request.RegisterRequest;
import org.youngmonkeys.ezyplatform.web.request.UpdateAvatarRequest;
import org.youngmonkeys.ezyplatform.web.request.UpdateCoverImageRequest;
import org.youngmonkeys.ezyplatform.web.request.UpdatePasswordRequest;
import org.youngmonkeys.ezyplatform.web.request.UpdateUserRequest;
import org.youngmonkeys.ezyplatform.web.service.WebPaginationUserService;
import org.youngmonkeys.ezyplatform.web.service.WebSettingService;
import org.youngmonkeys.ezyplatform.web.service.WebUserService;
import org.youngmonkeys.ezyplatform.web.validator.WebAuthenticationValidator;
import org.youngmonkeys.ezyplatform.web.validator.WebUserValidator;

@EzySingleton
public class WebUserControllerService
extends UserControllerService {
    private final WebSettingService settingService;
    private final WebUserService userService;
    private final WebAuthenticationValidator authenticationValidator;
    private final WebUserValidator userValidator;
    private final WebRequestToModelConverter requestToModelConverter;

    public WebUserControllerService(WebSettingService settingService, WebUserService userService, WebPaginationUserService paginationUserService, WebUserPaginationParameterConverter userPaginationParameterConverter, WebAuthenticationValidator authenticationValidator, WebUserValidator userValidator, WebRequestToModelConverter requestToModelConverter) {
        super((PaginationUserService)paginationUserService, (UserPaginationParameterConverter)userPaginationParameterConverter);
        this.settingService = settingService;
        this.userService = userService;
        this.authenticationValidator = authenticationValidator;
        this.userValidator = userValidator;
        this.requestToModelConverter = requestToModelConverter;
    }

    public UserAccessTokenModel registerUser(RegisterRequest request) {
        return this.registerUser(request, UserStatus.INACTIVATED.toString());
    }

    public UserAccessTokenModel registerUser(RegisterRequest request, String userStatus) {
        this.authenticationValidator.validate(request);
        AddUserModel addUserModel = this.requestToModelConverter.toAddModel(request, userStatus);
        return this.userService.addUser(addUserModel);
    }

    public UserAccessTokenModel authenticateUser(LoginRequest request) {
        UserModel user = this.authenticationValidator.validate(request);
        return this.userService.getOrCreateAccessTokenByUserId(user.getId(), user.getStatus());
    }

    public void updateUser(long userId, UpdateUserRequest request) {
        this.userValidator.validate(userId, request);
        this.userService.updateUser(this.requestToModelConverter.toUserModel(userId, request));
    }

    public void updateUserAvatar(long userId, UpdateAvatarRequest request) {
        this.userService.updateAvatar(userId, request.getAvatarId());
    }

    public void updateUserCoverImage(long userId, UpdateCoverImageRequest request) {
        this.userService.updateCoverImage(userId, request.getCoverImageId());
    }

    public void updateUserPassword(long userId, UpdatePasswordRequest request) {
        this.userValidator.validate(userId, request);
        this.userService.updatePassword(userId, request.getOldPassword(), request.getNewPassword());
    }

    public PaginationModel<UserModel> getUserPagination(String keyword, DefaultUserFilter.Builder<?> filterBuilder, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        return this.getUserPagination(keyword, filterBuilder, null, nextPageToken, prevPageToken, lastPage, limit);
    }

    public PaginationModel<UserModel> getUserPagination(String keyword, DefaultUserFilter.Builder<?> filterBuilder, String sortOrder, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        return this.getUserPagination(keyword, this.settingService.isAllowSearchUserByLikeOperator(), filterBuilder, sortOrder, nextPageToken, prevPageToken, lastPage, limit);
    }
}

