/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.gamebox.math;

import com.tvd12.gamebox.math.Vec2;

public class Rect {
    public float x;
    public float y;
    public float width;
    public float height;

    public Rect() {
    }

    public Rect(Rect r) {
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
    }

    public Rect(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setRect(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public float getMaxX() {
        return this.x + this.width;
    }

    public float getMidX() {
        return this.x + this.width / 2.0f;
    }

    public float getMinX() {
        return this.x;
    }

    public float getMaxY() {
        return this.y + this.height;
    }

    public float getMidY() {
        return this.y + this.height / 2.0f;
    }

    public float getMinY() {
        return this.y;
    }

    public boolean containsPoint(Vec2 point) {
        return point.x >= this.getMinX() && point.x <= this.getMaxX() && point.y >= this.getMinY() && point.y <= this.getMaxY();
    }

    public boolean intersectsRect(Rect rect) {
        return !(this.getMaxX() < rect.getMinX() || rect.getMaxX() < this.getMinX() || this.getMaxY() < rect.getMinY() || rect.getMaxY() < this.getMinY());
    }

    public boolean intersectsCircle(Vec2 center, float radius) {
        float centerX = this.x + this.width / 2.0f;
        float centerY = this.y + this.height / 2.0f;
        float w = this.width / 2.0f;
        float h = this.height / 2.0f;
        float dx = Math.abs(center.x - centerX);
        float dy = Math.abs(center.y - centerY);
        if (dx > radius + w || dy > radius + h) {
            return false;
        }
        float circleDistanceX = Math.abs(center.x - this.x - w);
        float circleDistanceY = Math.abs(center.y - this.y - h);
        if (circleDistanceX <= w) {
            return true;
        }
        if (circleDistanceY <= h) {
            return true;
        }
        float cornerDistanceSq = (float)(Math.pow(circleDistanceX - w, 2.0) + Math.pow(circleDistanceY - h, 2.0));
        return cornerDistanceSq <= (float)Math.pow(radius, 2.0);
    }

    public void merge(Rect rect) {
        float minX = Math.min(this.getMinX(), rect.getMinX());
        float minY = Math.min(this.getMinY(), rect.getMinY());
        float maxX = Math.max(this.getMaxX(), rect.getMaxX());
        float maxY = Math.max(this.getMaxY(), rect.getMaxY());
        this.setRect(minX, minY, maxX - minX, maxY - minY);
    }

    public Rect unionWithRect(Rect rect) {
        float tmp;
        float tmp2;
        float thisLeftX = this.x;
        float thisRightX = this.x + this.width;
        float thisTopY = this.y + this.height;
        float thisBottomY = this.y;
        if (thisRightX < thisLeftX) {
            tmp2 = thisRightX;
            thisRightX = thisLeftX;
            thisLeftX = tmp2;
        }
        if (thisTopY < thisBottomY) {
            tmp2 = thisTopY;
            thisTopY = thisBottomY;
            thisBottomY = tmp2;
        }
        float otherLeftX = rect.x;
        float otherRightX = rect.x + rect.width;
        float otherTopY = rect.y + rect.height;
        float otherBottomY = rect.y;
        if (otherRightX < otherLeftX) {
            tmp = otherRightX;
            otherRightX = otherLeftX;
            otherLeftX = tmp;
        }
        if (otherTopY < otherBottomY) {
            tmp = otherTopY;
            otherTopY = otherBottomY;
            otherBottomY = tmp;
        }
        float combinedLeftX = Math.min(thisLeftX, otherLeftX);
        float combinedRightX = Math.max(thisRightX, otherRightX);
        float combinedTopY = Math.max(thisTopY, otherTopY);
        float combinedBottomY = Math.min(thisBottomY, otherBottomY);
        return new Rect(combinedLeftX, combinedBottomY, combinedRightX - combinedLeftX, combinedTopY - combinedBottomY);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + " | " + this.width + ", " + this.height + ")";
    }
}

