/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.binding.impl;

import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.binding.annotation.EzyObjectBinding;
import com.tvd12.ezyfox.binding.impl.EzyAbstractReaderBuilder;
import com.tvd12.ezyfox.binding.impl.EzyElementsFetcher;
import com.tvd12.ezyfox.binding.impl.EzyObjectElementsFetcher;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.reflect.EzyByFieldMethod;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyGenericSetterValidator;
import com.tvd12.ezyfox.reflect.EzyGenerics;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyReflectElement;
import com.tvd12.ezyfox.reflect.EzySetterMethod;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public class EzyObjectReaderBuilder
extends EzyAbstractReaderBuilder {
    protected static final AtomicInteger COUNT = new AtomicInteger(0);
    protected static boolean debug;

    public EzyObjectReaderBuilder(EzyClass clazz) {
        super(clazz);
    }

    @Override
    protected int getAccessType(EzyClass clazz) {
        EzyObjectBinding ann = (EzyObjectBinding)clazz.getAnnotation(EzyObjectBinding.class);
        return ann == null ? 3 : ann.accessType();
    }

    @Override
    protected EzyElementsFetcher newElementsFetcher() {
        return new EzyObjectReaderElementsFetcher();
    }

    @Override
    protected String makeImplMethodContent(EzyMethod readMethod) {
        EzyFunction.EzyBody methodBody = new EzyFunction(readMethod).modifier("protected").body().append(new EzyInstruction("\t", "\n").variable(EzyObject.class, "value").equal().cast(EzyObject.class, "arg1"));
        this.appendOutputObjectConstructor(methodBody);
        for (Object element : this.getElements()) {
            if (element instanceof EzyField && !((EzyField)element).isWritable()) continue;
            methodBody.append(this.checkNotNullInstruction((EzyReflectElement)element));
            methodBody.append(this.newInstructionByElement(element));
        }
        this.addPostReadMethods(methodBody);
        methodBody.append(new EzyInstruction("\t", "\n").answer().append("object"));
        EzyFunction method = methodBody.function();
        return method.toString();
    }

    protected EzyInstruction newInstructionByElement(Object element) {
        if (element instanceof EzyField) {
            return this.newInstructionByField((EzyField)element);
        }
        return this.newInstructionByMethod((EzyMethod)element);
    }

    protected EzyInstruction newInstructionByField(EzyField field) {
        EzyInstruction instruction = new EzyInstruction("\t\t", "\n").append("object").dot().append(field.getName()).equal();
        EzyInstruction unmarshalInstruction = this.newUnmarshalInstruction((EzyReflectElement)field);
        instruction.append(unmarshalInstruction.toString());
        return instruction;
    }

    protected EzyInstruction newInstructionByMethod(EzyMethod method) {
        EzyInstruction instruction = new EzyInstruction("\t\t", "\n").append("object").dot().append(method.getName()).bracketopen();
        EzyInstruction unmarshalInstruction = this.newUnmarshalInstruction((EzyReflectElement)method);
        instruction.append(unmarshalInstruction.toString()).bracketclose();
        return instruction;
    }

    protected EzyInstruction checkNotNullInstruction(EzyReflectElement element) {
        return new EzyInstruction("\t", "\n", false).append("if").bracketopen().append("value").dot().append("isNotNullValue").bracketopen().string(this.getKey(element)).bracketclose().bracketclose();
    }

    protected EzyInstruction newUnmarshalInstruction(EzyReflectElement element) {
        Set<Class> commonGenericTypes = this.getCommonGenericTypes();
        Class type = this.getElementType(element);
        Class readerImpl = this.getReaderImplClass(element);
        EzyInstruction instruction = readerImpl != null || !commonGenericTypes.contains(type) ? this.newUnmarshalNormalInstruction(element, readerImpl) : this.newUnmarshalGenericInstruction(element);
        return this.wrapUnmarshalInstruction(instruction, type);
    }

    protected EzyInstruction newUnmarshalGenericInstruction(EzyReflectElement element) {
        Class genericType = this.getElementType(element);
        if (Map.class.isAssignableFrom(genericType)) {
            return this.newUnmarshalMapInstruction(element);
        }
        return this.newUnmarshalCollectionInstruction(element);
    }

    protected EzyInstruction newUnmarshalMapInstruction(EzyReflectElement element) {
        Class mapType = this.getElementType(element);
        Type genericType = this.getElementGenericType(element);
        Class[] keyValueTypes = EzyGenerics.getTwoGenericClassArguments((Type)genericType);
        return new EzyInstruction("", "", false).append("arg0.unmarshalMap").bracketopen().bracketopen().clazz(Object.class).bracketclose().append("value.getValue(").string(this.getKey(element)).comma().clazz(mapType, true).bracketclose().comma().clazz(mapType, true).comma().clazz(keyValueTypes[0], true).comma().clazz(keyValueTypes[1], true).bracketclose();
    }

    protected EzyInstruction newUnmarshalCollectionInstruction(EzyReflectElement element) {
        Class collectionType = this.getElementType(element);
        Type genericType = this.getElementGenericType(element);
        Class itemType = EzyGenerics.getOneGenericClassArgument((Type)genericType);
        return new EzyInstruction("", "", false).append("arg0.unmarshalCollection").bracketopen().bracketopen().clazz(Object.class).bracketclose().append("value.getValue(").string(this.getKey(element)).comma().clazz(collectionType, true).bracketclose().comma().clazz(collectionType, true).comma().clazz(itemType, true).bracketclose();
    }

    protected EzyInstruction newUnmarshalNormalInstruction(EzyReflectElement element, Class readerImpl) {
        EzyInstruction instruction = new EzyInstruction("", "", false).append("arg0.unmarshal").bracketopen();
        if (readerImpl != null) {
            instruction.clazz(readerImpl, true).comma();
        }
        Class type = this.getElementType(element);
        instruction.bracketopen().clazz(Object.class).bracketclose().append("value.getValue(").string(this.getKey(element)).comma().clazz(type, true).bracketclose();
        if (readerImpl == null) {
            instruction.comma().clazz(type, true);
        }
        instruction.bracketclose();
        return instruction;
    }

    @Override
    protected void appendConstructorParamValue(EzyInstruction instruction, Parameter parameter, int parameterIndex, EzyField field, String key) {
        instruction.append("value").dot().append("isNotNullValue").bracketopen().string(key).bracketclose().append(" ? ").append(this.newUnmarshalInstruction((EzyReflectElement)field)).append(" : ").defaultValue(parameter.getType());
    }

    @Override
    protected String getImplClassName() {
        return this.clazz.getName() + "$EzyObjectReader$EzyAutoImpl$" + COUNT.incrementAndGet();
    }

    @Override
    protected boolean isDebug() {
        return debug;
    }

    @Generated
    public static void setDebug(boolean debug) {
        EzyObjectReaderBuilder.debug = debug;
    }

    public static class EzyObjectReaderElementsFetcher
    extends EzyObjectElementsFetcher {
        private final EzyGenericSetterValidator setterValidator = new EzyGenericSetterValidator();

        @Override
        protected boolean isValidGenericField(EzyField field) {
            return this.setterValidator.validate(field.getGenericType());
        }

        @Override
        protected boolean isValidGenericMethod(EzyMethod method) {
            return this.setterValidator.validate(((EzyByFieldMethod)method).getGenericType());
        }

        @Override
        protected List<? extends EzyMethod> getMethodList(EzyClass clazz) {
            return clazz.getSetterMethods();
        }

        @Override
        protected List<? extends EzyMethod> getDeclaredMethods(EzyClass clazz) {
            return clazz.getDeclaredSetterMethods();
        }

        @Override
        protected EzyMethod newByFieldMethod(EzyMethod method) {
            return new EzySetterMethod(method);
        }

        @Override
        protected boolean isValidAnnotatedMethod(EzyMethod method) {
            return method.getParameterCount() == 1;
        }
    }
}

