/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.util.EzyStartable;
import com.tvd12.ezyfoxserver.EzyLoader;
import com.tvd12.ezyfoxserver.EzyServer;
import com.tvd12.ezyfoxserver.EzyServerBootstrap;
import com.tvd12.ezyfoxserver.builder.EzyServerBootstrapBuilder;
import com.tvd12.ezyfoxserver.config.EzyConfig;
import com.tvd12.ezyfoxserver.config.EzyConfigLoader;
import com.tvd12.ezyfoxserver.config.EzySimpleConfigLoader;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.setting.EzySettings;
import com.tvd12.ezyfoxserver.setting.EzySettingsDecorator;
import com.tvd12.ezyfoxserver.wrapper.EzySimpleSessionManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EzyStarter
implements EzyStartable {
    private final String configFile;
    private final EzySettingsDecorator settingsDecorator;
    private EzyServerContext serverContext;

    protected EzyStarter(Builder<?> builder) {
        this.configFile = builder.configFile;
        this.settingsDecorator = builder.settingsDecorator;
    }

    public void start() throws Exception {
        this.startSystem();
    }

    protected void startSystem() throws Exception {
        EzyConfig config = this.readConfig(this.configFile);
        this.startSystem(config);
    }

    protected void startSystem(EzyConfig config) throws Exception {
        this.setSystemProperties(config);
        this.startEzyFox(config);
    }

    protected void startEzyFox(EzyConfig config) throws Exception {
        this.startEzyFox(this.loadEzyFox(config));
    }

    protected void startEzyFox(EzyServer server) throws Exception {
        EzyConfig config = server.getConfig();
        if (config.isPrintSettings()) {
            this.getLogger().info("settings: \n{}", (Object)server);
        }
        EzyServerBootstrap serverBoostrap = this.newServerBoostrap(server);
        serverBoostrap.start();
        this.serverContext = serverBoostrap.getContext();
        this.serverContext.setProperty(EzyServerBootstrap.class, (Object)serverBoostrap);
    }

    protected EzyServerBootstrap newServerBoostrap(EzyServer server) {
        return (EzyServerBootstrap)((Object)this.newServerBootstrapBuilder().server(server).build());
    }

    protected abstract EzyServerBootstrapBuilder newServerBootstrapBuilder();

    protected void setSystemProperties(EzyConfig config) {
    }

    protected EzyServer loadEzyFox(EzyConfig config) {
        return this.newLoader().config(config).classLoader(this.getClassLoader()).settingsDecorator(this.settingsDecorator).load();
    }

    protected EzyLoader newLoader() {
        return new EzyLoader(){

            @Override
            protected EzySimpleSessionManager.Builder createSessionManagerBuilder(EzySettings settings) {
                return EzyStarter.this.newSessionManagerBuilder(settings);
            }
        };
    }

    protected abstract EzySimpleSessionManager.Builder newSessionManagerBuilder(EzySettings var1);

    protected EzyConfigLoader getConfigLoader() {
        return new EzySimpleConfigLoader();
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected EzyConfig readConfig(String configFile) throws Exception {
        return (EzyConfig)this.getConfigLoader().load(configFile);
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @Generated
    public EzyServerContext getServerContext() {
        return this.serverContext;
    }

    public static abstract class Builder<B extends Builder<B>>
    implements EzyBuilder<EzyStarter> {
        protected String configFile;
        protected EzySettingsDecorator settingsDecorator;

        public B configFile(String configFile) {
            this.configFile = configFile;
            return (B)this;
        }

        public B settingsDecorator(EzySettingsDecorator settingsDecorator) {
            this.settingsDecorator = settingsDecorator;
            return (B)this;
        }
    }
}

