/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.api;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.api.EzyResponseApi;
import com.tvd12.ezyfoxserver.constant.EzyTransportType;
import com.tvd12.ezyfoxserver.entity.EzySession;
import com.tvd12.ezyfoxserver.response.EzyPackage;
import com.tvd12.ezyfoxserver.socket.EzyPacket;
import com.tvd12.ezyfoxserver.socket.EzySimplePacket;
import java.util.Collection;

public abstract class EzyAbstractResponseApi
extends EzyLoggable
implements EzyResponseApi {
    @Override
    public void response(EzyPackage pack, boolean immediate) throws Exception {
        if (pack.isEncrypted()) {
            this.secureResponse(pack, immediate);
        } else {
            this.normalResponse(pack, immediate);
        }
    }

    protected final void normalResponse(EzyPackage pack, boolean immediate) throws Exception {
        EzyConstant connectionType = this.getConnectionType();
        Collection<EzySession> recipients = pack.getRecipients(connectionType);
        if (recipients.isEmpty()) {
            return;
        }
        Object bytes = this.encodeData(pack.getData());
        EzyConstant transportType = pack.getTransportType();
        if (immediate) {
            for (EzySession session : recipients) {
                EzyPacket packet = null;
                try {
                    packet = this.createPacket(session, transportType, bytes);
                    this.sendPacketNow(session, packet);
                }
                catch (Throwable e) {
                    if (packet != null) {
                        packet.release();
                    }
                    this.logger.info("response data now to session: {} failed", (Object)session, (Object)e);
                }
            }
        } else {
            for (EzySession session : recipients) {
                EzyPacket packet = null;
                try {
                    packet = this.createPacket(session, transportType, bytes);
                    this.sendPacket(session, packet);
                }
                catch (Throwable e) {
                    if (packet != null) {
                        packet.release();
                    }
                    this.logger.info("response data to session: {} failed", (Object)session, (Object)e);
                }
            }
        }
    }

    protected final void secureResponse(EzyPackage pack, boolean immediate) throws Exception {
        EzyConstant connectionType = this.getConnectionType();
        Collection<EzySession> recipients = pack.getRecipients(connectionType);
        if (recipients.isEmpty()) {
            return;
        }
        byte[] messageContent = this.dataToMessageContent(pack.getData());
        EzyConstant transportType = pack.getTransportType();
        if (immediate) {
            for (EzySession session : recipients) {
                EzyPacket packet = null;
                try {
                    byte[] bytes = this.encryptMessageContent(messageContent, session.getSessionKey());
                    packet = this.createPacket(session, transportType, bytes);
                    this.sendPacketNow(session, packet);
                }
                catch (Throwable e) {
                    if (packet != null) {
                        packet.release();
                    }
                    this.logger.info("response data now to session: {} failed", (Object)session, (Object)e);
                }
            }
        } else {
            for (EzySession session : recipients) {
                EzyPacket packet = null;
                try {
                    byte[] bytes = this.encryptMessageContent(messageContent, session.getSessionKey());
                    packet = this.createPacket(session, transportType, bytes);
                    this.sendPacket(session, packet);
                }
                catch (Throwable e) {
                    if (packet != null) {
                        packet.release();
                    }
                    this.logger.info("response data to session: {} failed", (Object)session, (Object)e);
                }
            }
        }
    }

    private EzyPacket createPacket(EzySession session, EzyConstant transportType, Object bytes) {
        EzyConstant actualTransportType = transportType;
        if (actualTransportType == EzyTransportType.UDP_OR_TCP) {
            actualTransportType = session.getDatagramChannelPool() != null ? EzyTransportType.UDP : EzyTransportType.TCP;
        }
        return this.createPacket(actualTransportType, bytes);
    }

    protected EzySimplePacket createPacket(EzyConstant transportType, Object bytes) {
        EzySimplePacket packet = new EzySimplePacket();
        packet.setTransportType(transportType);
        packet.setData(bytes);
        return packet;
    }

    private void sendPacket(EzySession session, EzyPacket packet) throws Exception {
        if (packet.getTransportType() == EzyTransportType.UDP) {
            session.send(packet);
        } else {
            this.sendTcpPacket(session, packet);
        }
    }

    protected void sendTcpPacket(EzySession session, EzyPacket packet) throws Exception {
        session.send(packet);
    }

    private void sendPacketNow(EzySession session, EzyPacket packet) throws Exception {
        if (packet.getTransportType() == EzyTransportType.UDP) {
            session.sendNow(packet);
        } else {
            this.sendTcpPacketNow(session, packet);
        }
    }

    protected void sendTcpPacketNow(EzySession session, EzyPacket packet) throws Exception {
        session.sendNow(packet);
    }

    protected abstract EzyConstant getConnectionType();

    protected abstract Object encodeData(EzyArray var1) throws Exception;

    protected byte[] dataToMessageContent(EzyArray data) throws Exception {
        throw new UnsupportedOperationException("unsupported");
    }

    protected byte[] encryptMessageContent(byte[] messageContent, byte[] encryptionKey) throws Exception {
        throw new UnsupportedOperationException("unsupported");
    }
}

