/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.api;

import com.tvd12.ezyfoxserver.api.EzyEmptyResponseApi;
import com.tvd12.ezyfoxserver.api.EzyResponseApi;
import com.tvd12.ezyfoxserver.api.EzySocketResponseApi;
import com.tvd12.ezyfoxserver.api.EzyWsResponseApi;
import com.tvd12.ezyfoxserver.codec.EzyCodecFactory;
import com.tvd12.ezyfoxserver.constant.EzyConnectionType;
import com.tvd12.ezyfoxserver.response.EzyPackage;

public class EzyProxyResponseApi
implements EzyResponseApi {
    private final EzyResponseApi websocketResponseApi;
    private final EzyResponseApi socketResponseApi;

    public EzyProxyResponseApi(EzyCodecFactory codecFactory) {
        Object socketEncoder = codecFactory.newEncoder(EzyConnectionType.SOCKET);
        Object wsEncoder = codecFactory.newEncoder(EzyConnectionType.WEBSOCKET);
        this.socketResponseApi = this.newSocketResponseApi(socketEncoder);
        this.websocketResponseApi = this.newWebsocketResponseApi(wsEncoder);
    }

    private EzyResponseApi newSocketResponseApi(Object socketEncoder) {
        return socketEncoder != null ? this.createSocketResponseApi(socketEncoder) : EzyEmptyResponseApi.getInstance();
    }

    protected EzySocketResponseApi createSocketResponseApi(Object socketEncoder) {
        return new EzySocketResponseApi(socketEncoder);
    }

    private EzyResponseApi newWebsocketResponseApi(Object wsEncoder) {
        return wsEncoder != null ? new EzyWsResponseApi(wsEncoder) : EzyEmptyResponseApi.getInstance();
    }

    @Override
    public void response(EzyPackage pack, boolean immediate) throws Exception {
        this.socketResponseApi.response(pack, immediate);
        this.websocketResponseApi.response(pack, immediate);
    }
}

