/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.command.impl;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyExceptionHandlers;
import com.tvd12.ezyfox.util.EzyExceptionHandlersFetcher;
import com.tvd12.ezyfoxserver.EzyPlugin;
import com.tvd12.ezyfoxserver.command.EzyAbstractCommand;
import com.tvd12.ezyfoxserver.command.EzyHandleException;

public class EzyPluginHandleExceptionImpl
extends EzyAbstractCommand
implements EzyHandleException {
    private final EzyPlugin plugin;
    private final EzyExceptionHandlersFetcher fetcher;

    public EzyPluginHandleExceptionImpl(EzyPlugin plugin) {
        this.plugin = plugin;
        this.fetcher = (EzyExceptionHandlersFetcher)plugin;
    }

    @Override
    public void handle(Thread thread, Throwable throwable) {
        String pluginName = this.plugin.getSetting().getName();
        EzyExceptionHandlers handlers = this.fetcher.getExceptionHandlers();
        if (handlers.isEmpty()) {
            this.logger.info("plugin: {} has no handler for exception:", (Object)pluginName, (Object)throwable);
        } else {
            try {
                handlers.handleException(thread, throwable);
            }
            catch (Exception e) {
                this.logger.warn("handle exception: {} on plugin: {} error", new Object[]{EzyStrings.exceptionToSimpleString((Throwable)throwable), pluginName, e});
            }
        }
    }
}

