/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.cli.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.tvd12.ezyfox.jackson.JacksonObjectMapperBuilder;
import com.tvd12.properties.file.reader.BaseFileReader;
import com.tvd12.properties.file.reader.FileReader;
import org.youngmonkeys.ezyplatform.cli.arguments.Arguments;
import org.youngmonkeys.ezyplatform.cli.handler.CommandHandler;
import org.youngmonkeys.ezyplatform.cli.io.CliClasspathBuilder;
import org.youngmonkeys.ezyplatform.util.OS;
import org.youngmonkeys.ezyplatform.util.OSType;

public abstract class AbstractCommandHandler<A extends Arguments>
implements CommandHandler<A> {
    protected final ObjectMapper objectMapper;
    protected final FileReader propertiesFileReader = new BaseFileReader();

    public AbstractCommandHandler() {
        this.objectMapper = JacksonObjectMapperBuilder.newInstance().build();
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    protected final void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final void println(String msg) {
        System.out.println(msg);
    }

    protected final void runBashFile(String bashFile, String arg) throws Exception {
        this.runBashFile(bashFile, arg, false);
    }

    protected final void runBashFile(String bashFile) throws Exception {
        this.runBashFile(bashFile, null, true);
    }

    protected final void runBashFile(String bashFile, String arg, boolean viewLog) throws Exception {
        ProcessBuilder processBuilder;
        OSType osType = OS.currentType();
        if (osType == OSType.WINDOWS) {
            String actualBashFile = bashFile.replace("/", "\\").replace(".sh", ".bat");
            processBuilder = arg != null ? new ProcessBuilder("cmd.exe", "/c", actualBashFile, "\"" + arg + "\"") : new ProcessBuilder("cmd.exe", "/c", actualBashFile);
        } else {
            processBuilder = arg != null ? new ProcessBuilder("bash", bashFile, arg) : new ProcessBuilder("bash", bashFile);
        }
        if (viewLog) {
            processBuilder.inheritIO();
        }
        Process process = processBuilder.start();
        process.waitFor();
    }

    protected final String buildClasspath(String target) throws Exception {
        return CliClasspathBuilder.getInstance().build(target);
    }
}

