/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.cli.handler;

import java.io.File;
import org.youngmonkeys.ezyplatform.cli.arguments.Arguments;
import org.youngmonkeys.ezyplatform.cli.arguments.ListArguments;
import org.youngmonkeys.ezyplatform.cli.handler.AbstractCommandHandler;
import org.youngmonkeys.ezyplatform.cli.io.CliFolderProxy;
import org.youngmonkeys.ezyplatform.entity.TargetType;

public class ListCommandHandler
extends AbstractCommandHandler<ListArguments> {
    @Override
    public void handle(ListArguments args) throws Exception {
        StringBuilder builder = new StringBuilder();
        for (TargetType targetType : TargetType.values()) {
            File[] containerFolders;
            String target = targetType.getName();
            builder.append(target);
            for (File containerFolder : containerFolders = CliFolderProxy.getContainerFoldersByTarget(target)) {
                File[] moduleFolders;
                if (containerFolder.isFile()) continue;
                builder.append("\n  ").append(containerFolder.getName());
                for (File moduleFolder : moduleFolders = CliFolderProxy.listFiles(containerFolder)) {
                    File[] files;
                    if (moduleFolder.isFile()) continue;
                    builder.append("\n    ").append(moduleFolder.getName());
                    if (!args.isAll()) continue;
                    for (File file : files = CliFolderProxy.listFiles(moduleFolder)) {
                        if (file.isHidden()) continue;
                        builder.append("\n      ").append(file.getName());
                    }
                }
            }
            builder.append("\n");
        }
        this.println(builder.toString().trim());
    }

    @Override
    public Arguments parse(String string) {
        return new ListArguments("-a".equals(string));
    }
}

