/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tvd12.ezyfox.io.EzyStrings;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.entity.UploadFrom;

public class MediaModel {
    private long id;
    private String name;
    private String url;
    private String originalName;
    private UploadFrom uploadFrom;
    private MediaType type;
    private String mimeType;
    private long ownerUserId;
    private long ownerAdminId;
    private String title;
    private String caption;
    private String alternativeText;
    private String description;
    private boolean publicMedia;
    private long createdAt;
    private long updatedAt;

    public static String getMediaUrlOrNull(MediaModel media) {
        return MediaModel.getMediaUrlOrDefault(media, null);
    }

    public static String getMediaUrlOrDefault(MediaModel media, String defaultUrl) {
        return media == null ? defaultUrl : media.getUrlOrDefault(defaultUrl);
    }

    public static String toMediaUrlOrDefault(String mediaName, String mediaUrl, String defaultUrl) {
        return EzyStrings.isBlank((String)mediaUrl) ? (EzyStrings.isBlank((String)mediaName) ? defaultUrl : "/api/v1/media/" + mediaName) : mediaUrl;
    }

    public static String toMeMediaUrlOrDefault(String mediaName, String mediaUrl, String defaultUrl) {
        return EzyStrings.isBlank((String)mediaUrl) ? (EzyStrings.isBlank((String)mediaName) ? defaultUrl : "/api/v1/me/media/" + mediaName) : mediaUrl;
    }

    @JsonIgnore
    public String getUrlOrNull() {
        return this.getUrlOrDefault(null);
    }

    public String getUrlOrDefault(String defaultUrl) {
        return MediaModel.toMediaUrlOrDefault(this.name, this.url, defaultUrl);
    }

    public String getMeUrlOrDefault(String defaultUrl) {
        return MediaModel.toMeMediaUrlOrDefault(this.name, this.url, defaultUrl);
    }

    public String getOriginalName() {
        return EzyStrings.isBlank((String)this.originalName) ? this.name : this.originalName;
    }

    @Generated
    MediaModel(long id, String name, String url, String originalName, UploadFrom uploadFrom, MediaType type, String mimeType, long ownerUserId, long ownerAdminId, String title, String caption, String alternativeText, String description, boolean publicMedia, long createdAt, long updatedAt) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.originalName = originalName;
        this.uploadFrom = uploadFrom;
        this.type = type;
        this.mimeType = mimeType;
        this.ownerUserId = ownerUserId;
        this.ownerAdminId = ownerAdminId;
        this.title = title;
        this.caption = caption;
        this.alternativeText = alternativeText;
        this.description = description;
        this.publicMedia = publicMedia;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @Generated
    public static MediaModelBuilder builder() {
        return new MediaModelBuilder();
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public UploadFrom getUploadFrom() {
        return this.uploadFrom;
    }

    @Generated
    public MediaType getType() {
        return this.type;
    }

    @Generated
    public String getMimeType() {
        return this.mimeType;
    }

    @Generated
    public long getOwnerUserId() {
        return this.ownerUserId;
    }

    @Generated
    public long getOwnerAdminId() {
        return this.ownerAdminId;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getCaption() {
        return this.caption;
    }

    @Generated
    public String getAlternativeText() {
        return this.alternativeText;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isPublicMedia() {
        return this.publicMedia;
    }

    @Generated
    public long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public long getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public static class MediaModelBuilder {
        @Generated
        private long id;
        @Generated
        private String name;
        @Generated
        private String url;
        @Generated
        private String originalName;
        @Generated
        private UploadFrom uploadFrom;
        @Generated
        private MediaType type;
        @Generated
        private String mimeType;
        @Generated
        private long ownerUserId;
        @Generated
        private long ownerAdminId;
        @Generated
        private String title;
        @Generated
        private String caption;
        @Generated
        private String alternativeText;
        @Generated
        private String description;
        @Generated
        private boolean publicMedia;
        @Generated
        private long createdAt;
        @Generated
        private long updatedAt;

        @Generated
        MediaModelBuilder() {
        }

        @Generated
        public MediaModelBuilder id(long id) {
            this.id = id;
            return this;
        }

        @Generated
        public MediaModelBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MediaModelBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public MediaModelBuilder originalName(String originalName) {
            this.originalName = originalName;
            return this;
        }

        @Generated
        public MediaModelBuilder uploadFrom(UploadFrom uploadFrom) {
            this.uploadFrom = uploadFrom;
            return this;
        }

        @Generated
        public MediaModelBuilder type(MediaType type) {
            this.type = type;
            return this;
        }

        @Generated
        public MediaModelBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @Generated
        public MediaModelBuilder ownerUserId(long ownerUserId) {
            this.ownerUserId = ownerUserId;
            return this;
        }

        @Generated
        public MediaModelBuilder ownerAdminId(long ownerAdminId) {
            this.ownerAdminId = ownerAdminId;
            return this;
        }

        @Generated
        public MediaModelBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public MediaModelBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @Generated
        public MediaModelBuilder alternativeText(String alternativeText) {
            this.alternativeText = alternativeText;
            return this;
        }

        @Generated
        public MediaModelBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MediaModelBuilder publicMedia(boolean publicMedia) {
            this.publicMedia = publicMedia;
            return this;
        }

        @Generated
        public MediaModelBuilder createdAt(long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public MediaModelBuilder updatedAt(long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public MediaModel build() {
            return new MediaModel(this.id, this.name, this.url, this.originalName, this.uploadFrom, this.type, this.mimeType, this.ownerUserId, this.ownerAdminId, this.title, this.caption, this.alternativeText, this.description, this.publicMedia, this.createdAt, this.updatedAt);
        }

        @Generated
        public String toString() {
            return "MediaModel.MediaModelBuilder(id=" + this.id + ", name=" + this.name + ", url=" + this.url + ", originalName=" + this.originalName + ", uploadFrom=" + (Object)((Object)this.uploadFrom) + ", type=" + (Object)((Object)this.type) + ", mimeType=" + this.mimeType + ", ownerUserId=" + this.ownerUserId + ", ownerAdminId=" + this.ownerAdminId + ", title=" + this.title + ", caption=" + this.caption + ", alternativeText=" + this.alternativeText + ", description=" + this.description + ", publicMedia=" + this.publicMedia + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ")";
        }
    }
}

