/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.pagination;

import com.tvd12.ezyfox.io.EzyStrings;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.pagination.ComplexPaginationParameterConverter;
import org.youngmonkeys.ezyplatform.service.PaginationService;

public final class PaginationModelFetchers {
    private PaginationModelFetchers() {
    }

    public static <T> PaginationModel<T> getPaginationModel(PaginationService paginationService, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        return PaginationModelFetchers.getPaginationModel(paginationService, null, nextPageToken, prevPageToken, lastPage, limit);
    }

    public static <T> PaginationModel<T> getPaginationModel(PaginationService paginationService, Object filter, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        if (EzyStrings.isBlank((String)nextPageToken) && EzyStrings.isBlank((String)prevPageToken)) {
            if (lastPage) {
                return paginationService.getLastPage(filter, limit);
            }
            return paginationService.getFirstPage(filter, limit);
        }
        if (EzyStrings.isBlank((String)prevPageToken)) {
            return paginationService.getNextPage(filter, nextPageToken, limit);
        }
        return paginationService.getPreviousPage(filter, prevPageToken, limit);
    }

    public static <T> PaginationModel<T> getPaginationModelBySortOrder(PaginationService paginationService, ComplexPaginationParameterConverter paginationParameterConverter, Object filter, String sortOrder, String nextPageToken, String prevPageToken, boolean lastPage, int limit) {
        String actualNextPageToken = nextPageToken;
        String actualPrevPageToken = prevPageToken;
        if (sortOrder != null && nextPageToken == null && prevPageToken == null) {
            if (lastPage) {
                actualPrevPageToken = paginationParameterConverter.getDefaultPageToken(sortOrder);
            } else {
                actualNextPageToken = paginationParameterConverter.getDefaultPageToken(sortOrder);
            }
        }
        return PaginationModelFetchers.getPaginationModel(paginationService, filter, actualNextPageToken, actualPrevPageToken, lastPage, limit);
    }
}

