/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import java.util.Collections;
import java.util.List;

public final class Paginations {
    private Paginations() {
    }

    public static int getNumberOfPages(int total, int pageSize) {
        if (total % pageSize == 0) {
            return total / pageSize;
        }
        return total / pageSize + 1;
    }

    public static <T> List<T> getPageItems(List<T> items, int pageNumber, int pageSize) {
        int from = pageSize * (pageNumber - 1);
        if (from >= items.size()) {
            return Collections.emptyList();
        }
        int to = pageSize * pageNumber;
        if (from == to) {
            return Collections.emptyList();
        }
        if (to > items.size()) {
            to = items.size();
        }
        return items.subList(from, to);
    }
}

