/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.request;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.security.EzyBase64;
import com.tvd12.ezyhttp.core.constant.ContentTypes;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.net.PathVariables;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRequestArguments
implements RequestArguments {
    protected boolean debug;
    protected HttpMethod method;
    protected String uriTemplate;
    protected ObjectMapper objectMapper;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected Map<Object, Object> arguments;
    protected List<String> headerList;
    protected Map<String, String> headerMap;
    protected List<String> parameterList;
    protected Map<String, String> parameterMap;
    protected Map<String, String> pathVariableMap;
    protected List<Map.Entry<String, String>> pathVariableList;
    protected Cookie[] cookies;
    protected Map<String, Cookie> cookieMap;
    protected Map<String, Object> redirectionAttributes;
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleRequestArguments.class);

    @Override
    public <T> T getArgument(Object key) {
        Object argument;
        Object object = argument = this.arguments != null ? this.arguments.get(key) : null;
        if (argument == null && this.debug) {
            LOGGER.error("there is no value for argment: {}", key);
        }
        return (T)argument;
    }

    @Override
    public void setArgument(Object key, Object value) {
        if (this.arguments == null) {
            this.arguments = new HashMap<Object, Object>();
        }
        this.arguments.put(key, value);
    }

    @Override
    public String getParameter(int index) {
        if (this.parameterList == null) {
            return null;
        }
        if (this.parameterList.size() <= index) {
            return null;
        }
        return this.parameterList.get(index);
    }

    @Override
    public String getParameter(String name) {
        if (this.parameterMap == null) {
            return null;
        }
        return this.parameterMap.get(name);
    }

    public Map<String, String> getHeaders() {
        return this.headerMap;
    }

    public Map<String, String> getParameters() {
        return this.parameterMap;
    }

    public void setParameter(String name, String[] values) {
        if (values == null) {
            return;
        }
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<String>();
        }
        if (this.parameterMap == null) {
            this.parameterMap = new HashMap<String, String>();
        }
        String value = values.length == 0 ? "" : (values.length == 1 ? values[0] : String.join((CharSequence)",", values));
        this.parameterList.add(value);
        this.parameterMap.put(name, value);
    }

    @Override
    public String getHeader(int index) {
        if (this.headerList == null) {
            return null;
        }
        if (this.headerList.size() <= index) {
            return null;
        }
        return this.headerList.get(index);
    }

    @Override
    public String getHeader(String name) {
        if (this.headerMap == null) {
            return null;
        }
        return this.headerMap.get(name);
    }

    public void setHeader(String name, String value) {
        if (this.headerList == null) {
            this.headerList = new ArrayList<String>();
        }
        if (this.headerMap == null) {
            this.headerMap = new HashMap<String, String>();
        }
        this.headerList.add(value);
        this.headerMap.put(name, value);
    }

    @Override
    public String getPathVariable(int index) {
        this.fetchPathVariables();
        if (this.pathVariableList.size() <= index) {
            return null;
        }
        return this.pathVariableList.get(index).getValue();
    }

    @Override
    public String getPathVariable(String name) {
        this.fetchPathVariables();
        return this.pathVariableMap.get(name);
    }

    protected void fetchPathVariables() {
        if (this.pathVariableList == null) {
            this.pathVariableList = PathVariables.getVariables((String)this.uriTemplate, (String)this.request.getRequestURI());
            this.pathVariableMap = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.pathVariableList) {
                this.pathVariableMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
        this.setArgument(HttpServletRequest.class, request);
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
        this.setArgument(HttpServletResponse.class, response);
    }

    public String getContentType() {
        return ContentTypes.getContentType((String)this.request.getContentType());
    }

    public String getRequestContentType() {
        return this.request.getContentType();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public void setCookies(Cookie[] cookies) {
        if (cookies == null || cookies.length == 0) {
            return;
        }
        this.cookies = cookies;
        this.cookieMap = new HashMap<String, Cookie>();
        for (Cookie cookie : cookies) {
            Cookie old = this.cookieMap.get(cookie.getName());
            if (old != null && !EzyStrings.isBlank((String)old.getValue())) continue;
            this.cookieMap.put(cookie.getName(), cookie);
        }
    }

    @Override
    public String getCookieValue(int index) {
        if (this.cookies == null || this.cookies.length <= index) {
            return null;
        }
        String cookieName = this.cookies[index].getName();
        Cookie cookie = this.cookieMap.get(cookieName);
        return cookie.getValue();
    }

    @Override
    public String getCookieValue(String name) {
        Cookie cookie = this.getCookie(name);
        return cookie != null ? cookie.getValue() : null;
    }

    @Override
    public Cookie getCookie(String name) {
        return this.cookieMap != null ? this.cookieMap.get(name) : null;
    }

    public void setRedirectionAttributesFromCookie() {
        Cookie cookie = this.getCookie("ezyRedirectAttributes");
        if (cookie == null) {
            return;
        }
        try {
            String value = EzyBase64.decodeUtf((String)cookie.getValue());
            this.redirectionAttributes = (Map)this.objectMapper.readValue(value, Map.class);
        }
        catch (Exception value) {
            // empty catch block
        }
        Cookie newCookie = new Cookie("ezyRedirectAttributes", "");
        newCookie.setMaxAge(0);
        this.response.addCookie(newCookie);
    }

    @Override
    public <T> T getRedirectionAttribute(String name) {
        if (this.redirectionAttributes == null) {
            return null;
        }
        return (T)this.redirectionAttributes.get(name);
    }

    @Override
    public <T> T getRedirectionAttribute(String name, Class<T> outType) {
        T value = this.getRedirectionAttribute(name);
        return (T)(value != null ? this.objectMapper.convertValue(value, outType) : null);
    }

    @Override
    public AsyncContext getAsyncContext() {
        return this.request.getAsyncContext();
    }

    @Override
    public boolean isAsyncStarted() {
        return this.request.isAsyncStarted();
    }

    public void release() {
        if (this.arguments != null) {
            this.arguments.clear();
        }
        if (this.headerList != null) {
            this.headerList.clear();
        }
        if (this.headerMap != null) {
            this.headerMap.clear();
        }
        if (this.parameterList != null) {
            this.parameterList.clear();
        }
        if (this.parameterMap != null) {
            this.parameterMap.clear();
        }
        if (this.cookieMap != null) {
            this.cookieMap.clear();
        }
        if (this.pathVariableList != null) {
            this.pathVariableList.clear();
        }
        if (this.pathVariableMap != null) {
            this.pathVariableMap.clear();
        }
        if (this.redirectionAttributes != null) {
            this.redirectionAttributes.clear();
        }
        this.arguments = null;
        this.headerList = null;
        this.headerMap = null;
        this.parameterList = null;
        this.parameterMap = null;
        this.cookies = null;
        this.cookieMap = null;
        this.pathVariableList = null;
        this.pathVariableMap = null;
        this.request = null;
        this.response = null;
        this.objectMapper = null;
        this.redirectionAttributes = null;
    }

    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Generated
    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    @Override
    @Generated
    public HttpMethod getMethod() {
        return this.method;
    }

    @Generated
    public void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    @Override
    @Generated
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    @Generated
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    @Generated
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    @Generated
    public Map<String, Object> getRedirectionAttributes() {
        return this.redirectionAttributes;
    }
}

