/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.resources;

import com.tvd12.ezyfox.bean.EzyPropertyFetcher;
import com.tvd12.ezyhttp.core.resources.ResourceDownloadManager;
import com.tvd12.ezyhttp.core.resources.ResourceUploadManager;
import com.tvd12.ezyhttp.server.core.resources.ResourceResolver;

public final class ResourceResolvers {
    private ResourceResolvers() {
    }

    public static ResourceResolver createResourceResolver(EzyPropertyFetcher propertyFetcher) {
        String[] stringArray;
        String pattern;
        boolean resourceEnable = (Boolean)propertyFetcher.getProperty((Object)"resources.enable", Boolean.TYPE, (Object)false);
        if (!resourceEnable) {
            return null;
        }
        String[] resourceLocations = (String[])propertyFetcher.getProperty((Object)"resources.locations", String[].class);
        if (resourceLocations == null) {
            String resourceLocation = (String)propertyFetcher.getProperty((Object)"resources.location", String.class, (Object)"static");
            resourceLocations = new String[]{resourceLocation};
        }
        if ((pattern = (String)propertyFetcher.getProperty((Object)"resources.pattern", String.class)) != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = pattern;
        } else {
            stringArray = new String[]{};
        }
        String[] patterns = stringArray;
        ResourceResolver resourceResolver = new ResourceResolver();
        resourceResolver.register(resourceLocations, patterns);
        return resourceResolver;
    }

    public static ResourceDownloadManager createDownloadManager(EzyPropertyFetcher propertyFetcher) {
        int capacity = (Integer)propertyFetcher.getProperty((Object)"resources.download.capacity", Integer.TYPE, (Object)100000);
        int threadPoolSize = (Integer)propertyFetcher.getProperty((Object)"resources.download.thread_pool_size", Integer.TYPE, (Object)ResourceDownloadManager.DEFAULT_THREAD_POOL_SIZE);
        int bufferSize = (Integer)propertyFetcher.getProperty((Object)"resources.download.buffer_size", Integer.TYPE, (Object)1024);
        return new ResourceDownloadManager(capacity, threadPoolSize, bufferSize);
    }

    public static ResourceUploadManager createUploadManager(EzyPropertyFetcher propertyFetcher) {
        int capacity = (Integer)propertyFetcher.getProperty((Object)"resources.upload.capacity", Integer.TYPE, (Object)100000);
        int threadPoolSize = (Integer)propertyFetcher.getProperty((Object)"resources.upload.thread_pool_size", Integer.TYPE, (Object)ResourceUploadManager.DEFAULT_THREAD_POOL_SIZE);
        int bufferSize = (Integer)propertyFetcher.getProperty((Object)"resources.upload.buffer_size", Integer.TYPE, (Object)1024);
        return new ResourceUploadManager(capacity, threadPoolSize, bufferSize);
    }
}

