/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.statistics;

import com.tvd12.ezyfox.function.EzyExceptionApply;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.client.HttpClient;
import com.tvd12.ezyhttp.client.request.PostRequest;
import com.tvd12.ezyhttp.client.request.Request;
import com.tvd12.ezyhttp.client.request.RequestEntity;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.concurrent.DefaultThreadFactory;
import org.youngmonkeys.ezyplatform.manager.EnvironmentManager;
import org.youngmonkeys.ezyplatform.manager.EzyPlatformKeyManager;
import org.youngmonkeys.ezyplatform.manager.MarketUrlManager;
import org.youngmonkeys.ezyplatform.service.SettingService;

public class EzyPlatformStatisticsSender
extends EzyLoggable {
    protected final HttpClient httpClient;
    protected final SettingService settingService;
    protected final MarketUrlManager marketUrlManager;
    protected final EzyPlatformKeyManager platformKeyManager;
    protected final EnvironmentManager environmentManager;
    protected final ThreadFactory threadFactory = DefaultThreadFactory.create((String)"statistics");

    public void sendStartupStatistics() {
        this.sendStatistics((EzyExceptionApply<String>)((EzyExceptionApply)platformKey -> {
            String platformVersion = this.environmentManager.getPlatformVersion();
            this.httpClient.request((Request)((PostRequest)new PostRequest().setURL(this.marketUrlManager.getSendStartupStatisticsUrl(platformVersion))).setEntity(RequestEntity.builder().header("platformKey", platformKey).body(this.getSendStartupStatisticsData()).build()));
        }));
    }

    protected Object getSendStartupStatisticsData() {
        return null;
    }

    protected void sendStatistics(EzyExceptionApply<String> sender) {
        if (this.settingService.isAllowSendStatisticsData()) {
            this.threadFactory.newThread(() -> {
                try {
                    String platformKey = this.platformKeyManager.getPlatformKey();
                    if (EzyStrings.isBlank((String)platformKey)) {
                        return;
                    }
                    sender.apply((Object)platformKey);
                }
                catch (Exception e) {
                    this.logger.info("send statistics error", (Throwable)e);
                }
            }).start();
        }
    }

    @Generated
    public EzyPlatformStatisticsSender(HttpClient httpClient, SettingService settingService, MarketUrlManager marketUrlManager, EzyPlatformKeyManager platformKeyManager, EnvironmentManager environmentManager) {
        this.httpClient = httpClient;
        this.settingService = settingService;
        this.marketUrlManager = marketUrlManager;
        this.platformKeyManager = platformKeyManager;
        this.environmentManager = environmentManager;
    }
}

