/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.validator;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import java.util.Collections;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.service.UserService;

public class UserValidator {
    private final UserService userService;

    public UserModel validateUserId(long userId) {
        UserModel user = this.userService.getUserById(userId);
        if (user == null) {
            throw new HttpNotFoundException(Collections.singletonMap("user", "notFound"));
        }
        return user;
    }

    public UserModel validateUserUuid(String uuid) {
        UserModel user = null;
        if (EzyStrings.isNotBlank((String)uuid)) {
            user = this.userService.getUserByUuid(uuid);
        }
        if (user == null) {
            throw new HttpNotFoundException(Collections.singletonMap("user", "notFound"));
        }
        return user;
    }

    public UserModel validateUsername(String username) {
        UserModel user = null;
        if (EzyStrings.isNotBlank((String)username)) {
            user = this.userService.getUserByUsername(username);
        }
        if (user == null) {
            throw new HttpNotFoundException(Collections.singletonMap("user", "notFound"));
        }
        return user;
    }

    @Generated
    public UserValidator(UserService userService) {
        this.userService = userService;
    }
}

