/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;

public class FileItem {
    protected File file;
    protected int level;
    protected FileItem parent;
    protected String relativePath;
    protected List<FileItem> children = new ArrayList<FileItem>();

    public int childrenCount() {
        return this.children.size();
    }

    public void walk(Consumer<FileItem> consumer) {
        consumer.accept(this);
        for (FileItem child : this.children) {
            child.walk(consumer);
        }
    }

    public void walkChildren(Consumer<FileItem> consumer) {
        for (FileItem child : this.children) {
            if (child.childrenCount() == 0) {
                consumer.accept(child);
                continue;
            }
            child.walkChildren(consumer);
        }
    }

    public List<FileItem> flatChildren() {
        return this.flatChildren(true);
    }

    public List<FileItem> flatChildren(boolean sort) {
        ArrayList<FileItem> answer = new ArrayList<FileItem>();
        this.walkChildren(answer::add);
        if (sort) {
            answer.sort(Comparator.comparing(a -> a.relativePath));
        }
        return answer;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Generated
    public FileItem getParent() {
        return this.parent;
    }

    @Generated
    public String getRelativePath() {
        return this.relativePath;
    }

    @Generated
    public List<FileItem> getChildren() {
        return this.children;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileItem)) {
            return false;
        }
        FileItem other = (FileItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        return result;
    }

    public static class FileItemMutable
    extends FileItem {
        public FileItemMutable setFile(File file) {
            this.file = file;
            return this;
        }

        public FileItemMutable setLevel(int level) {
            this.level = level;
            return this;
        }

        public FileItemMutable setParent(FileItem parent) {
            this.parent = parent;
            return this;
        }

        public FileItemMutable setRelativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        public FileItemMutable addChild(FileItem child) {
            this.children.add(child);
            return this;
        }
    }
}

