/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.model;

import com.tvd12.ezyfox.io.EzyLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;

public class PaginationModel<T> {
    private List<T> items;
    private PageToken pageToken;
    private Continuation continuation;
    private int count;
    private long total;
    private long timestamp;
    public static final PaginationModel EMPTY_PAGINATION = PaginationModel.builder().pageToken(PageToken.builder().build()).continuation(Continuation.builder().build()).items(Collections.emptyList()).build();

    public static <T> PaginationModel<T> emptyPagination() {
        return EMPTY_PAGINATION;
    }

    public <R> PaginationModel<R> map(Function<T, R> mapper) {
        return this.newItems(EzyLists.newArrayList(this.items, mapper));
    }

    public <R> PaginationModel<R> mapIndex(BiFunction<T, Integer, R> mapper) {
        ArrayList<R> newItems = new ArrayList<R>();
        for (int i = 0; i < this.items.size(); ++i) {
            newItems.add(mapper.apply(this.items.get(i), i));
        }
        return this.newItems(newItems);
    }

    public <R> PaginationModel<R> newItems(List<R> items) {
        return PaginationModel.builder().items(items).pageToken(this.pageToken).continuation(this.continuation).count(this.count).total(this.total).timestamp(this.timestamp).build();
    }

    @Generated
    PaginationModel(List<T> items, PageToken pageToken, Continuation continuation, int count, long total, long timestamp) {
        this.items = items;
        this.pageToken = pageToken;
        this.continuation = continuation;
        this.count = count;
        this.total = total;
        this.timestamp = timestamp;
    }

    @Generated
    public static <T> PaginationModelBuilder<T> builder() {
        return new PaginationModelBuilder();
    }

    @Generated
    public List<T> getItems() {
        return this.items;
    }

    @Generated
    public PageToken getPageToken() {
        return this.pageToken;
    }

    @Generated
    public Continuation getContinuation() {
        return this.continuation;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Generated
    public long getTotal() {
        return this.total;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String toString() {
        return "PaginationModel(items=" + this.getItems() + ", pageToken=" + this.getPageToken() + ", continuation=" + this.getContinuation() + ", count=" + this.getCount() + ", total=" + this.getTotal() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @Generated
    public static class PaginationModelBuilder<T> {
        @Generated
        private List<T> items;
        @Generated
        private PageToken pageToken;
        @Generated
        private Continuation continuation;
        @Generated
        private int count;
        @Generated
        private long total;
        @Generated
        private long timestamp;

        @Generated
        PaginationModelBuilder() {
        }

        @Generated
        public PaginationModelBuilder<T> items(List<T> items) {
            this.items = items;
            return this;
        }

        @Generated
        public PaginationModelBuilder<T> pageToken(PageToken pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        @Generated
        public PaginationModelBuilder<T> continuation(Continuation continuation) {
            this.continuation = continuation;
            return this;
        }

        @Generated
        public PaginationModelBuilder<T> count(int count) {
            this.count = count;
            return this;
        }

        @Generated
        public PaginationModelBuilder<T> total(long total) {
            this.total = total;
            return this;
        }

        @Generated
        public PaginationModelBuilder<T> timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public PaginationModel<T> build() {
            return new PaginationModel<T>(this.items, this.pageToken, this.continuation, this.count, this.total, this.timestamp);
        }

        @Generated
        public String toString() {
            return "PaginationModel.PaginationModelBuilder(items=" + this.items + ", pageToken=" + this.pageToken + ", continuation=" + this.continuation + ", count=" + this.count + ", total=" + this.total + ", timestamp=" + this.timestamp + ")";
        }
    }

    public static class Continuation {
        private boolean hasNext;
        private boolean hasPrevious;

        @Generated
        Continuation(boolean hasNext, boolean hasPrevious) {
            this.hasNext = hasNext;
            this.hasPrevious = hasPrevious;
        }

        @Generated
        public static ContinuationBuilder builder() {
            return new ContinuationBuilder();
        }

        @Generated
        public boolean isHasNext() {
            return this.hasNext;
        }

        @Generated
        public boolean isHasPrevious() {
            return this.hasPrevious;
        }

        @Generated
        public String toString() {
            return "PaginationModel.Continuation(hasNext=" + this.isHasNext() + ", hasPrevious=" + this.isHasPrevious() + ")";
        }

        @Generated
        public static class ContinuationBuilder {
            @Generated
            private boolean hasNext;
            @Generated
            private boolean hasPrevious;

            @Generated
            ContinuationBuilder() {
            }

            @Generated
            public ContinuationBuilder hasNext(boolean hasNext) {
                this.hasNext = hasNext;
                return this;
            }

            @Generated
            public ContinuationBuilder hasPrevious(boolean hasPrevious) {
                this.hasPrevious = hasPrevious;
                return this;
            }

            @Generated
            public Continuation build() {
                return new Continuation(this.hasNext, this.hasPrevious);
            }

            @Generated
            public String toString() {
                return "PaginationModel.Continuation.ContinuationBuilder(hasNext=" + this.hasNext + ", hasPrevious=" + this.hasPrevious + ")";
            }
        }
    }

    public static class PageToken {
        private String next;
        private String prev;

        @Generated
        PageToken(String next, String prev) {
            this.next = next;
            this.prev = prev;
        }

        @Generated
        public static PageTokenBuilder builder() {
            return new PageTokenBuilder();
        }

        @Generated
        public String getNext() {
            return this.next;
        }

        @Generated
        public String getPrev() {
            return this.prev;
        }

        @Generated
        public String toString() {
            return "PaginationModel.PageToken(next=" + this.getNext() + ", prev=" + this.getPrev() + ")";
        }

        @Generated
        public static class PageTokenBuilder {
            @Generated
            private String next;
            @Generated
            private String prev;

            @Generated
            PageTokenBuilder() {
            }

            @Generated
            public PageTokenBuilder next(String next) {
                this.next = next;
                return this;
            }

            @Generated
            public PageTokenBuilder prev(String prev) {
                this.prev = prev;
                return this;
            }

            @Generated
            public PageToken build() {
                return new PageToken(this.next, this.prev);
            }

            @Generated
            public String toString() {
                return "PaginationModel.PageToken.PageTokenBuilder(next=" + this.next + ", prev=" + this.prev + ")";
            }
        }
    }
}

