/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.repo;

import com.tvd12.ezydata.jpa.repository.EzyJpaRepository;
import java.time.LocalDateTime;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.youngmonkeys.ezyplatform.entity.DataRecordCount;

public class DataRecordCountTransactionalRepository
extends EzyJpaRepository<String, DataRecordCount> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRecordCount(String dataType, long value) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = entityManager.createNativeQuery("UPDATE ezy_data_record_counts e SET e.record_count = GREATEST(0, e.record_count + ?1) WHERE e.data_type = ?0");
            query.setParameter(0, (Object)dataType);
            query.setParameter(1, (Object)value);
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                query.executeUpdate();
                transaction.commit();
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementRecordCount(String dataType, long value, long lastRecordId, LocalDateTime time) {
        try (EntityManager entityManager = this.databaseContext.createEntityManager();){
            Query query = entityManager.createNativeQuery("UPDATE ezy_data_record_counts e SET e.record_count = GREATEST(0, e.record_count + ?1), e.last_record_id = CASE WHEN ?1 > 0 THEN ?2 ELSE e.last_record_id END, e.last_counted_at = ?3 WHERE e.data_type = ?0");
            query.setParameter(0, (Object)dataType);
            query.setParameter(1, (Object)value);
            query.setParameter(2, (Object)lastRecordId);
            query.setParameter(3, (Object)time);
            EntityTransaction transaction = entityManager.getTransaction();
            transaction.begin();
            try {
                query.executeUpdate();
                transaction.commit();
            }
            catch (Exception e) {
                transaction.rollback();
                throw e;
            }
        }
    }

    protected Class<DataRecordCount> getEntityType() {
        return DataRecordCount.class;
    }
}

