/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.security.EzyBase64;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.youngmonkeys.ezyplatform.service.AdminAccessTokenService;
import org.youngmonkeys.ezyplatform.service.SettingService;
import org.youngmonkeys.ezyplatform.util.AccessTokens;

public class DefaultAdminAccessTokenService
implements AdminAccessTokenService {
    private static final AtomicBoolean WATCHED = new AtomicBoolean();
    private static final AtomicReference<byte[]> ENCRYPTION_KEY = new AtomicReference();

    public DefaultAdminAccessTokenService(SettingService settingService) {
        if (WATCHED.compareAndSet(false, true)) {
            this.watchLastEncryptionKeyUpdatedTime(settingService);
        }
    }

    private void watchLastEncryptionKeyUpdatedTime(SettingService settingService) {
        settingService.watchLastUpdatedTime("admin_access_token_encryption_key", () -> ENCRYPTION_KEY.set(EzyBase64.decode((String)settingService.getDecryptionValue("admin_access_token_encryption_key"))));
    }

    @Override
    public String generateAccessToken(long adminId) {
        return AccessTokens.generateAccessToken("admin", adminId, ENCRYPTION_KEY.get());
    }

    @Override
    public long extractAdminId(String accessToken) {
        return AccessTokens.extractSourceId(accessToken, ENCRYPTION_KEY.get());
    }
}

