/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Collection;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.model.AddUserKeywordModel;
import org.youngmonkeys.ezyplatform.repo.UserKeywordRepository;
import org.youngmonkeys.ezyplatform.repo.UserKeywordTransactionalRepository;
import org.youngmonkeys.ezyplatform.service.UserKeywordService;

public class DefaultUserKeywordService
extends EzyLoggable
implements UserKeywordService {
    private final UserKeywordRepository userKeywordRepository;
    private final UserKeywordTransactionalRepository userKeywordTransactionalRepository;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public void addUserKeyword(AddUserKeywordModel model) {
        this.userKeywordTransactionalRepository.saveUserKeyword(this.modelToEntityConverter.toEntity(model));
    }

    @Override
    public void addUserKeywords(Collection<AddUserKeywordModel> userKeywords) {
        this.userKeywordTransactionalRepository.saveUserKeywords(EzyLists.newArrayList(userKeywords, this.modelToEntityConverter::toEntity));
    }

    @Override
    public void deleteUserKeywordsByUserId(long userId) {
        this.userKeywordRepository.deleteByUserId(userId);
    }

    @Override
    public void deleteUserKeywordsByUserIds(Collection<Long> userIds) {
        if (userIds.size() > 0) {
            this.userKeywordRepository.deleteByUserIdIn(userIds);
        }
    }

    @Override
    public boolean containsUserKeyword(long userId, String keyword) {
        return this.userKeywordRepository.findByUserIdAndKeyword(userId, keyword) != null;
    }

    @Generated
    public DefaultUserKeywordService(UserKeywordRepository userKeywordRepository, UserKeywordTransactionalRepository userKeywordTransactionalRepository, DefaultModelToEntityConverter modelToEntityConverter) {
        this.userKeywordRepository = userKeywordRepository;
        this.userKeywordTransactionalRepository = userKeywordTransactionalRepository;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

